"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureFleetGlobalEsAssets = ensureFleetGlobalEsAssets;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _pMap = _interopRequireDefault(require("p-map"));
var _install = require("../epm/elasticsearch/template/install");
var _install2 = require("../epm/elasticsearch/ingest_pipeline/install");
var _packages = require("../epm/packages");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Ensure ES assets shared by all Fleet index template are installed
 */
async function ensureFleetGlobalEsAssets({
  logger,
  soClient,
  esClient
}, options) {
  // Ensure Global Fleet ES assets are installed
  logger.debug('Creating Fleet component template and ingest pipeline');
  const globalAssetsRes = await Promise.all([(0, _install.ensureDefaultComponentTemplates)(esClient, logger),
  // returns an array
  (0, _install2.ensureFleetFinalPipelineIsInstalled)(esClient, logger), (0, _install2.ensureFleetEventIngestedPipelineIsInstalled)(esClient, logger)]);
  if (options !== null && options !== void 0 && options.reinstallPackages) {
    const assetResults = globalAssetsRes.flat();
    if (assetResults.some(asset => asset.isCreated)) {
      // Update existing index template
      const installedPackages = await (0, _packages.getInstallations)(soClient);
      await (0, _pMap.default)(installedPackages.saved_objects, async ({
        attributes: installation
      }) => {
        await (0, _packages.reinstallPackageForInstallation)({
          soClient,
          esClient,
          installation
        }).catch(err => {
          _elasticApmNode.default.captureError(err);
          logger.error(`Package needs to be manually reinstalled ${installation.name} after installing Fleet global assets: ${err.message}`);
        });
      }, {
        concurrency: _constants.MAX_CONCURRENT_EPM_PACKAGES_INSTALLATIONS
      });
    }
  }
}