"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changeAgentPrivilegeLevel = changeAgentPrivilegeLevel;
var _lodash = require("lodash");
var _errors = require("../../errors");
var _package_policy = require("../package_policy");
var _actions = require("./actions");
var _crud = require("./crud");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function changeAgentPrivilegeLevel(esClient, soClient, agentId, options) {
  var _options$user_info;
  // Fail fast if agent contains an integration that requires root access.
  const agent = await (0, _crud.getAgentById)(esClient, soClient, agentId);
  const packagePolicies = (await _package_policy.packagePolicyService.findAllForAgentPolicy(soClient, agent.policy_id || '')) || [];
  const packagesWithRootAccess = packagePolicies.map(policy => policy.package).filter(pkg => pkg && pkg.requires_root);
  if (packagesWithRootAccess.length > 0) {
    throw new _errors.FleetUnauthorizedError(`Agent policy ${agent.policy_id} contains integrations that require root access: ${packagesWithRootAccess.map(pkg => pkg === null || pkg === void 0 ? void 0 : pkg.name).join(', ')}`);
  }

  // Extract password from options if provided and pass it as a secret.
  const res = await (0, _actions.createAgentAction)(esClient, soClient, {
    agents: [agentId],
    created_at: new Date().toISOString(),
    type: 'PRIVILEGE_LEVEL_CHANGE',
    data: {
      unprivileged: true,
      ...((options === null || options === void 0 ? void 0 : options.user_info) && {
        user_info: (0, _lodash.omit)(options === null || options === void 0 ? void 0 : options.user_info, ['password'])
      })
    },
    ...((options === null || options === void 0 ? void 0 : (_options$user_info = options.user_info) === null || _options$user_info === void 0 ? void 0 : _options$user_info.password) && {
      secrets: {
        user_info: {
          password: options.user_info.password
        }
      }
    })
  });
  return {
    actionId: res.id
  };
}