"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLEET_ACTIONS_CHANNEL_NAME = void 0;
exports.sendActionTelemetryEvents = sendActionTelemetryEvents;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLEET_ACTIONS_CHANNEL_NAME = exports.FLEET_ACTIONS_CHANNEL_NAME = 'fleet-actions';
function sendActionTelemetryEvents(logger, eventsTelemetry, actionEvent) {
  if (eventsTelemetry === undefined) {
    return;
  }
  try {
    eventsTelemetry.queueTelemetryEvents(FLEET_ACTIONS_CHANNEL_NAME, [actionEvent]);
  } catch (exc) {
    logger.error(`queuing telemetry events failed ${exc}`);
  }
}