"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.packagePolicyV17AdvancedFieldsForEndpointV818 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const packagePolicyV17AdvancedFieldsForEndpointV818 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    const policy = input.config.policy.value;
    for (const os of ['windows', 'mac', 'linux']) {
      var _policyPerOs$advanced, _policyPerOs$advanced2, _policyPerOs$advanced3, _policyPerOs$advanced4, _policyPerOs$advanced5, _policyPerOs$advanced6;
      const policyPerOs = policy[os];
      policyPerOs.advanced = {
        set_extended_host_information: true,
        ...policyPerOs.advanced,
        events: {
          aggregate_process: false,
          aggregate_network: false,
          ...((_policyPerOs$advanced = policyPerOs.advanced) === null || _policyPerOs$advanced === void 0 ? void 0 : _policyPerOs$advanced.events),
          hash: {
            md5: true,
            sha1: true,
            ...((_policyPerOs$advanced2 = policyPerOs.advanced) === null || _policyPerOs$advanced2 === void 0 ? void 0 : (_policyPerOs$advanced3 = _policyPerOs$advanced2.events) === null || _policyPerOs$advanced3 === void 0 ? void 0 : _policyPerOs$advanced3.hash)
          }
        },
        alerts: {
          ...((_policyPerOs$advanced4 = policyPerOs.advanced) === null || _policyPerOs$advanced4 === void 0 ? void 0 : _policyPerOs$advanced4.alerts),
          hash: {
            md5: true,
            sha1: true,
            ...((_policyPerOs$advanced5 = policyPerOs.advanced) === null || _policyPerOs$advanced5 === void 0 ? void 0 : (_policyPerOs$advanced6 = _policyPerOs$advanced5.alerts) === null || _policyPerOs$advanced6 === void 0 ? void 0 : _policyPerOs$advanced6.hash)
          }
        }
      };
    }
  }
  return {
    attributes: {
      ...updatedPackagePolicyDoc.attributes,
      bump_agent_policy_revision: true
    }
  };
};
exports.packagePolicyV17AdvancedFieldsForEndpointV818 = packagePolicyV17AdvancedFieldsForEndpointV818;