"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _api_privileges = require("../../constants/api_privileges");
var _uninstall_token = require("../../types/rest_spec/uninstall_token");
var _errors = require("../schema/errors");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = (router, config) => {
  router.versioned.get({
    path: _constants.UNINSTALL_TOKEN_ROUTES.LIST_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL]
      }
    },
    summary: 'Get metadata for latest uninstall tokens',
    description: 'List the metadata for the latest uninstall tokens per agent policy.',
    options: {
      tags: ['oas-tag:Fleet uninstall tokens']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _uninstall_token.GetUninstallTokensMetadataRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _uninstall_token.GetUninstallTokensMetadataResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handlers.getUninstallTokensMetadataHandler);
  router.versioned.get({
    path: _constants.UNINSTALL_TOKEN_ROUTES.INFO_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.AGENTS.ALL]
      }
    },
    summary: 'Get a decrypted uninstall token',
    description: 'Get one decrypted uninstall token by its ID.',
    options: {
      tags: ['oas-tag:Fleet uninstall tokens']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _uninstall_token.GetUninstallTokenRequestSchema,
      response: {
        200: {
          description: 'OK: A successful request.',
          body: () => _uninstall_token.GetUninstallTokenResponseSchema
        },
        400: {
          description: 'A bad request.',
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handlers.getUninstallTokenHandler);
};
exports.registerRoutes = registerRoutes;