"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateCloudFormationUrl = void 0;
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_FORMATION_DEFAULT_ACCOUNT_TYPE = 'single-account';
const useCreateCloudFormationUrl = ({
  enrollmentAPIKey,
  cloudFormationProps,
  fleetServerHost
}) => {
  const agentVersion = (0, _hooks.useAgentVersion)();
  let isError = false;
  let error;
  if (!fleetServerHost) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noFleetServerHost', {
      defaultMessage: 'No Fleet Server host found'
    });
  }
  if (!enrollmentAPIKey) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noApiKey', {
      defaultMessage: 'No enrollment token found'
    });
  }
  const cloudFormationUrl = enrollmentAPIKey && fleetServerHost && cloudFormationProps !== null && cloudFormationProps !== void 0 && cloudFormationProps.templateUrl && agentVersion ? createCloudFormationUrl(cloudFormationProps === null || cloudFormationProps === void 0 ? void 0 : cloudFormationProps.templateUrl, enrollmentAPIKey, fleetServerHost, agentVersion, cloudFormationProps === null || cloudFormationProps === void 0 ? void 0 : cloudFormationProps.awsAccountType) : undefined;
  return {
    cloudFormationUrl,
    isError,
    error
  };
};
exports.useCreateCloudFormationUrl = useCreateCloudFormationUrl;
const createCloudFormationUrl = (templateURL, enrollmentToken, fleetUrl, agentVersion, awsAccountType) => {
  let cloudFormationUrl;

  /*
    template url has `&param_ElasticAgentVersion=KIBANA_VERSION` part. KIBANA_VERSION is used for templating as agent version used to match Kibana version, but now it's not necessarily the case
   */
  cloudFormationUrl = templateURL.replace('FLEET_ENROLLMENT_TOKEN', encodeURIComponent(enrollmentToken)).replace('FLEET_URL', encodeURIComponent(fleetUrl)).replace('KIBANA_VERSION', encodeURIComponent(agentVersion));
  if (cloudFormationUrl.includes('ACCOUNT_TYPE')) {
    cloudFormationUrl = cloudFormationUrl.replace('ACCOUNT_TYPE', encodeURIComponent(getAwsAccountType(awsAccountType)));
  }
  return new URL(cloudFormationUrl).toString();
};
const getAwsAccountType = awsAccountType => {
  return awsAccountType ? awsAccountType : CLOUD_FORMATION_DEFAULT_ACCOUNT_TYPE;
};