"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallStandaloneAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _install_section = require("../../enrollment_instructions/install_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/install_standalone_agent_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InstallStandaloneAgentStep = ({
  installCommand,
  isK8s,
  cloudSecurityIntegration,
  isComplete,
  fullCopyButton,
  onCopy,
  rootIntegrations,
  nonFipsIntegrations
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepEnrollAndRunAgentTitle', {
      defaultMessage: 'Install Elastic Agent on your host'
    }),
    children: /*#__PURE__*/_react.default.createElement(_install_section.InstallSection, {
      installCommand: installCommand,
      isK8s: isK8s,
      cloudSecurityIntegration: cloudSecurityIntegration,
      onCopy: onCopy,
      fullCopyButton: fullCopyButton,
      isManaged: false,
      rootIntegrations: rootIntegrations,
      nonFipsIntegrations: nonFipsIntegrations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }),
    status: isComplete ? 'complete' : undefined
  };
};
exports.InstallStandaloneAgentStep = InstallStandaloneAgentStep;