"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddAgentHelpPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = require("styled-components");
var _hooks = require("../hooks");
var _use_dismissable_tour = require("../hooks/use_dismissable_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/components/add_agent_help_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddAgentHelpPopover = ({
  button,
  isOpen,
  offset,
  closePopover
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const theme = (0, _styledComponents.useTheme)();
  const optionalProps = {};
  const addAgentTour = (0, _use_dismissable_tour.useDismissableTour)('ADD_AGENT_POPOVER');
  if (offset !== undefined) {
    optionalProps.offset = offset; // offset being present in props sets it to 0 so only add if specified
  }
  return addAgentTour.isHidden ? button : /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({}, optionalProps, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      style: {
        width: 302
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.popoverBody",
      defaultMessage: "For integrations to work successfully, add {elasticAgent} to your host to collect data and send it to Elastic Stack. {learnMoreLink}",
      values: {
        elasticAgent: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 29
          }
        }, "Elastic Agent"),
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: docLinks.links.fleet.elasticAgent,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 54,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.addAgentHelpPopover.documentationLink",
          defaultMessage: "Learn more about Elastic Agent.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 55,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    })),
    zIndex: theme.eui.euiZLevel1 - 1 // put popover behind any modals that happen to be open
    ,
    isStepOpen: isOpen,
    minWidth: 300,
    onFinish: addAgentTour.dismiss,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.title",
      defaultMessage: "Don't forget to add the agent to your host",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }),
    anchorPosition: "downCenter",
    subtitle: null,
    "data-test-subj": "addAgentHelpPopover",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        addAgentTour.dismiss();
        closePopover();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.footActionButton",
      defaultMessage: "Got it",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }), button);
};
exports.AddAgentHelpPopover = AddAgentHelpPopover;