"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrationLabels = getIntegrationLabels;
exports.mapToCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _has_deferred_installations = require("../../../../../../services/has_deferred_installations");
var _services = require("../../../../../../../common/services");
var _constants = require("../../../../../../../common/constants");
var _services2 = require("../../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/home/card_utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mapToCard = ({
  getAbsolutePath,
  getHref,
  item,
  addBasePath,
  packageVerificationKeyId,
  selectedCategory
}) => {
  let uiInternalPathUrl;
  let isUnverified = false;
  let version = 'version' in item ? item.version || '' : '';
  let isUpdateAvailable = false;
  let isReauthorizationRequired = false;
  if (item.type === 'ui_link') {
    uiInternalPathUrl = item.id.includes('language_client.') ? addBasePath(item.uiInternalPath) : item.uiExternalLink || getAbsolutePath(item.uiInternalPath);
  } else {
    var _item$installationInf;
    if (item !== null && item !== void 0 && (_item$installationInf = item.installationInfo) !== null && _item$installationInf !== void 0 && _item$installationInf.version) {
      version = item.installationInfo.version || item.version;
      isUnverified = (0, _services2.isPackageUnverified)(item, packageVerificationKeyId);
      isUpdateAvailable = (0, _services2.isPackageUpdatable)(item);
      isReauthorizationRequired = (0, _has_deferred_installations.hasDeferredInstallations)(item);
    }
    const url = getHref('integration_details_overview', {
      pkgkey: `${item.name}-${version}`,
      ...(item.integration ? {
        integration: item.integration
      } : {})
    });
    uiInternalPathUrl = url;
  }
  const release = (0, _services.getPackageReleaseLabel)(version);
  let extraLabelsBadges;
  if (item.type === 'integration' || item.type === 'content') {
    extraLabelsBadges = getIntegrationLabels(item);
  }
  const cardResult = {
    id: `${item.type === 'ui_link' ? 'ui_link' : 'epr'}:${item.id}`,
    description: item.description || '',
    icons: !item.icons || !item.icons.length ? [] : item.icons,
    title: item.title,
    url: uiInternalPathUrl,
    fromIntegrations: selectedCategory,
    integration: 'integration' in item ? item.integration || '' : '',
    name: 'name' in item ? item.name : item.id,
    version,
    type: item.type,
    release,
    categories: (item.categories || []).filter(c => !!c),
    isReauthorizationRequired,
    isUnverified,
    isUpdateAvailable,
    extraLabelsBadges
  };
  if (item.type === 'integration') {
    var _item$installationInf2;
    cardResult.installStatus = (_item$installationInf2 = item.installationInfo) === null || _item$installationInf2 === void 0 ? void 0 : _item$installationInf2.install_status;
  }
  return cardResult;
};
exports.mapToCard = mapToCard;
function getIntegrationLabels(item) {
  var _item$installationInf3, _item$installationInf4, _item$installationInf7;
  const extraLabelsBadges = [];
  if (item !== null && item !== void 0 && (_item$installationInf3 = item.installationInfo) !== null && _item$installationInf3 !== void 0 && (_item$installationInf4 = _item$installationInf3.latest_install_failed_attempts) !== null && _item$installationInf4 !== void 0 && _item$installationInf4.some(attempt => item.installationInfo && (0, _lt.default)(item.installationInfo.version, attempt.target_version))) {
    var _item$installationInf5, _item$installationInf6;
    const updateFailedAttempt = (_item$installationInf5 = item.installationInfo) === null || _item$installationInf5 === void 0 ? void 0 : (_item$installationInf6 = _item$installationInf5.latest_install_failed_attempts) === null || _item$installationInf6 === void 0 ? void 0 : _item$installationInf6.find(attempt => item.installationInfo && (0, _lt.default)(item.installationInfo.version, attempt.target_version));
    extraLabelsBadges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: "update_failed_badge",
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.packageCard.updateFailedTooltipTitle",
        defaultMessage: "Update failed",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 15
        }
      }),
      content: updateFailedAttempt ? formatAttempt(updateFailedAttempt) : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      iconType: "error",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.updateFailed",
      defaultMessage: "Update failed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 15
      }
    }))))));
  }
  if (((_item$installationInf7 = item.installationInfo) === null || _item$installationInf7 === void 0 ? void 0 : _item$installationInf7.install_status) === _constants.installationStatuses.InstallFailed) {
    var _item$installationInf8, _item$installationInf9;
    const installFailedAttempt = (_item$installationInf8 = item.installationInfo) === null || _item$installationInf8 === void 0 ? void 0 : (_item$installationInf9 = _item$installationInf8.latest_install_failed_attempts) === null || _item$installationInf9 === void 0 ? void 0 : _item$installationInf9.find(attempt => {
      var _item$installationInf10;
      return attempt.target_version === ((_item$installationInf10 = item.installationInfo) === null || _item$installationInf10 === void 0 ? void 0 : _item$installationInf10.version);
    });
    extraLabelsBadges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: "install_failed_badge",
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.packageCard.installFailedTooltipTitle",
        defaultMessage: "Install failed",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 15
        }
      }),
      content: installFailedAttempt ? formatAttempt(installFailedAttempt) : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      iconType: "error",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.installFailed",
      defaultMessage: "Install failed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 15
      }
    }))))));
  }
  return extraLabelsBadges;
}
function formatAttempt(attempt) {
  var _attempt$error, _attempt$error2;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packageCard.faileAttemptDescription",
    defaultMessage: "Failed at {attemptDate}.",
    values: {
      attemptDate: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: attempt.created_at,
        year: "numeric",
        month: "short",
        day: "numeric",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " @ "), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: attempt.created_at,
        hour: "numeric",
        minute: "numeric",
        second: "numeric",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 242,
          columnNumber: 15
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }, ((_attempt$error = attempt.error) === null || _attempt$error === void 0 ? void 0 : _attempt$error.name) || '', " : ", ((_attempt$error2 = attempt.error) === null || _attempt$error2 === void 0 ? void 0 : _attempt$error2.message) || ''));
}