"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeferredAssetsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
var _types = require("../../../../../types");
var _models = require("../../../../../../../../common/types/models");
var _deferred_assets_warning = require("./deferred_assets_warning");
var _deferred_assets_accordion = require("./deferred_assets_accordion");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/assets/deferred_assets_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DeferredAssetsSection = ({
  deferredInstallations,
  packageInfo,
  forceRefreshAssets
}) => {
  const authz = (0, _hooks.useAuthz)();
  const deferredTransforms = deferredInstallations.filter(asset => asset.type === _types.ElasticsearchAssetType.transform);
  const deferredAlerts = deferredInstallations.filter(asset => asset.type === _models.KibanaSavedObjectType.alert);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.assets.deferredInstallationsLabel",
    defaultMessage: "Deferred installations",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    iconType: "alert",
    title: (0, _deferred_assets_warning.getDeferredInstallationMsg)(deferredInstallations.length, {
      authz
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_deferred_assets_accordion.DeferredAssetsAccordion, {
    packageInfo: packageInfo,
    type: _types.ElasticsearchAssetType.transform,
    deferredInstallations: deferredTransforms,
    forceRefreshAssets: forceRefreshAssets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_deferred_assets_accordion.DeferredAssetsAccordion, {
    packageInfo: packageInfo,
    type: _models.KibanaSavedObjectType.alert,
    deferredInstallations: deferredAlerts,
    forceRefreshAssets: forceRefreshAssets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }));
};
exports.DeferredAssetsSection = DeferredAssetsSection;