"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._promoteFeaturedIntegrations = _promoteFeaturedIntegrations;
exports.promoteFeaturedIntegrations = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/custom-integrations-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function _promoteFeaturedIntegrations(featuredIntegrationsByCategory, packageList, selectedCategory) {
  const featuredIntegrationNames = featuredIntegrationsByCategory[selectedCategory];
  if (!featuredIntegrationNames) return packageList;
  const [featuredIntegrations, otherIntegrations] = (0, _lodash.partition)(packageList, card => featuredIntegrationNames.includes(card.name));

  // Create a new array to keep the order and all matched integrations
  const orderedFeaturedIntegrations = [];
  for (const name of featuredIntegrationNames) {
    const matchingIntegrations = featuredIntegrations.filter(({
      name: integrationName
    }) => integrationName === name);
    orderedFeaturedIntegrations.push(...matchingIntegrations);
  }
  return [...orderedFeaturedIntegrations, ...otherIntegrations];
}
const promoteFeaturedIntegrations = exports.promoteFeaturedIntegrations = _promoteFeaturedIntegrations.bind(null, _common.FEATURED_INTEGRATIONS_BY_CATEGORY);