"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../hooks");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/tag_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TagOptions = ({
  tagName,
  isTagHovered,
  onTagsUpdated
}) => {
  const [tagOptionsVisible, setTagOptionsVisible] = (0, _react.useState)(false);
  const [tagOptionsButton, setTagOptionsButton] = (0, _react.useState)();
  const [tagMenuButtonVisible, setTagMenuButtonVisible] = (0, _react.useState)(isTagHovered);
  const [updatedName, setUpdatedName] = (0, _react.useState)(tagName);
  (0, _react.useEffect)(() => {
    setTagMenuButtonVisible(isTagHovered || tagOptionsVisible);
  }, [isTagHovered, tagOptionsVisible]);
  (0, _react.useEffect)(() => {
    setUpdatedName(tagName);
  }, [tagName]);
  const closePopover = (isDelete = false) => {
    setTagOptionsVisible(false);
    if (isDelete) {
      handleDelete();
    } else {
      handleRename(updatedName);
    }
  };
  const updateTagsHook = (0, _hooks.useUpdateTags)();
  const bulkUpdateTags = updateTagsHook.bulkUpdateTags;
  const TAGS_QUERY = 'tags:"{name}"';
  const handleRename = newName => {
    if (newName === tagName || !newName) {
      return;
    }
    const kuery = TAGS_QUERY.replace('{name}', tagName);
    bulkUpdateTags(kuery, [newName], [tagName], hasCompleted => onTagsUpdated([newName], [tagName], hasCompleted), _i18n.i18n.translate('xpack.fleet.renameAgentTags.successNotificationTitle', {
      defaultMessage: 'Tag renamed'
    }), _i18n.i18n.translate('xpack.fleet.renameAgentTags.errorNotificationTitle', {
      defaultMessage: 'Tag rename failed'
    }));
  };
  const handleDelete = () => {
    const kuery = TAGS_QUERY.replace('{name}', tagName);
    updateTagsHook.bulkUpdateTags(kuery, [], [tagName], hasCompleted => onTagsUpdated([], [tagName], hasCompleted), _i18n.i18n.translate('xpack.fleet.deleteAgentTags.successNotificationTitle', {
      defaultMessage: 'Tag deleted'
    }), _i18n.i18n.translate('xpack.fleet.deleteAgentTags.errorNotificationTitle', {
      defaultMessage: 'Tag delete failed'
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tagMenuButtonVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "boxesHorizontal",
    "aria-label": _i18n.i18n.translate('xpack.fleet.tagOptions.tagOptionsToggleButtonLabel', {
      defaultMessage: 'Tag Options'
    }),
    color: "text",
    onClick: event => {
      setTagOptionsButton(event.currentTarget);
      setTagOptionsVisible(!tagOptionsVisible);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), tagOptionsVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: true,
    button: tagOptionsButton,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.fleet.tagOptions.nameTextFieldPlaceholder', {
      defaultMessage: 'Enter new name for tag'
    }),
    value: updatedName,
    required: true,
    onKeyDown: e => {
      if (e.key === 'Enter') {
        closePopover();
      }
    },
    onChange: e => {
      const newName = e.currentTarget.value;
      setUpdatedName((0, _utils.sanitizeTag)(newName));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "danger",
    onClick: () => {
      closePopover(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "trash",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.tagOptions.deleteText",
    defaultMessage: "Delete tag",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }))))));
};
exports.TagOptions = TagOptions;