"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../components");
var _activity_section = require("./activity_section");
var _go_to_date = require("./go_to_date");
var _agent_activity_helper = require("./agent_activity_helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agent_activity_flyout/flyout_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FullHeightFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    height: 100%;
  }
`;
const ButtonsFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding-left: 24px;
`;
const ScrollAnchor = _styledComponents.default.div`
  height: 0;
  margin: 0;
  padding: 0;
`;
const FlyoutBody = ({
  isFirstLoading,
  currentActions,
  abortUpgrade,
  onClickViewAgents,
  onClickManageAutoUpgradeAgents,
  areActionsFullyLoaded,
  onClickShowMore,
  dateFilter,
  onChangeDateFilter
}) => {
  const scrollToTopRef = _react.default.useRef(null);
  _react.default.useEffect(() => {
    var _scrollToTopRef$curre;
    // Condition needed for jest tests as scrollIntoView is not implemented in jsdom
    if ((_scrollToTopRef$curre = scrollToTopRef.current) !== null && _scrollToTopRef$curre !== void 0 && _scrollToTopRef$curre.scrollIntoView) {
      scrollToTopRef.current.scrollIntoView();
    }
  }, [dateFilter]);
  // Loading
  if (isFirstLoading) {
    return /*#__PURE__*/_react.default.createElement(FullHeightFlyoutBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: 'center',
      alignItems: 'center',
      className: "eui-fullHeight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }))));
  }

  // No actions
  if (currentActions.length === 0) {
    return /*#__PURE__*/_react.default.createElement(FullHeightFlyoutBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(ScrollAnchor, {
      ref: scrollToTopRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      justifyContent: 'center',
      alignItems: 'center',
      className: "eui-fullHeight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "clock",
      iconColor: "default",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 17
        }
      }, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.noActivityText",
        defaultMessage: "No activity to display",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 19
        }
      })),
      titleSize: "m",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.noActivityDescription",
        defaultMessage: "Activity feed will appear here as agents are reassigned, upgraded, or unenrolled.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 17
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_go_to_date.GoToDate, {
      selectedDate: dateFilter,
      onChangeSelectedDate: onChangeDateFilter,
      filledStyle: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => onChangeDateFilter(null),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.emptyState.showMoreButton",
      defaultMessage: "Clear selected date",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 15
      }
    })))));
  }

  // Loaded actions

  const inProgressActions = currentActions.filter(a => a.status === 'IN_PROGRESS');
  const completedActions = currentActions.filter(a => a.status !== 'IN_PROGRESS');
  const todayActions = (0, _agent_activity_helper.getTodayActions)(completedActions);
  const otherDays = (0, _agent_activity_helper.getOtherDaysActions)(completedActions);
  return /*#__PURE__*/_react.default.createElement(FullHeightFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ScrollAnchor, {
    ref: scrollToTopRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, inProgressActions.length > 0 ? /*#__PURE__*/_react.default.createElement(_activity_section.ActivitySection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.inProgressTitle",
      defaultMessage: "In progress",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 19
      }
    }),
    actions: inProgressActions,
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents,
    onClickManageAutoUpgradeAgents: onClickManageAutoUpgradeAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  }) : null, todayActions.length > 0 ? /*#__PURE__*/_react.default.createElement(_activity_section.ActivitySection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.todayTitle",
      defaultMessage: "Today",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 19
      }
    }),
    actions: todayActions,
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents,
    onClickManageAutoUpgradeAgents: onClickManageAutoUpgradeAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }) : null, Object.keys(otherDays).map(day => /*#__PURE__*/_react.default.createElement(_activity_section.ActivitySection, {
    key: day,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: day,
      year: "numeric",
      month: "short",
      day: "2-digit",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 24
      }
    }),
    actions: otherDays[day],
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents,
    onClickManageAutoUpgradeAgents: onClickManageAutoUpgradeAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ButtonsFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    onClick: onClickShowMore,
    disabled: areActionsFullyLoaded,
    flush: "left",
    "data-test-subj": "agentActivityFlyout.showMoreButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.showMoreButton",
    defaultMessage: "Show more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_go_to_date.GoToDate, {
    selectedDate: dateFilter,
    onChangeSelectedDate: onChangeDateFilter,
    filledStyle: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  })), dateFilter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    onClick: () => onChangeDateFilter(null),
    flush: "left",
    "data-test-subj": "agentActivityFlyout.clearSelectedDateButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.clearSelectedDateutton",
    defaultMessage: "Clear selected date",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 19
    }
  })))))));
};
exports.FlyoutBody = FlyoutBody;