"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDashboardLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../../common/constants");
var _dashboard_helpers = require("../../services/dashboard_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/components/agent_dashboard_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isKibanaAssetsInstalledInSpace(spaceId, res) {
  var _res$item, _installationInfo$add;
  if ((res === null || res === void 0 ? void 0 : (_res$item = res.item) === null || _res$item === void 0 ? void 0 : _res$item.status) !== 'installed') {
    return false;
  }
  const installationInfo = res.item.installationInfo;
  if (!installationInfo || installationInfo.install_status !== 'installed') {
    return false;
  }
  return installationInfo.installed_kibana_space_id === spaceId || spaceId && ((_installationInfo$add = installationInfo.additional_spaces_installed_kibana) === null || _installationInfo$add === void 0 ? void 0 : _installationInfo$add[spaceId]);
}
function useAgentDashboardLink(agent) {
  const {
    isLoading,
    data
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(_constants.FLEET_ELASTIC_AGENT_PACKAGE);
  const {
    spaceId
  } = (0, _hooks.useFleetStatus)();
  const isInstalled = isKibanaAssetsInstalledInSpace(spaceId, data);
  const dashboardLocator = (0, _hooks.useDashboardLocator)();
  const link = dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
    dashboardId: (0, _dashboard_helpers.getDashboardIdForSpace)(spaceId, data, _constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_AGENT_METRICS),
    query: {
      language: 'kuery',
      query: `elastic_agent.id:${agent.id}`
    }
  });
  return {
    isLoading,
    isInstalled,
    link
  };
}
const EuiButtonCompressed = (0, _styledComponents.default)(_eui.EuiButton)`
  height: 32px;
`;
const AgentDashboardLink = ({
  agent,
  agentPolicy
}) => {
  var _agentPolicy$monitori, _agentPolicy$monitori2;
  const {
    isInstalled,
    link,
    isLoading
  } = useAgentDashboardLink(agent);
  const {
    getHref
  } = (0, _hooks.useLink)();
  const isLogAndMetricsEnabled = (_agentPolicy$monitori = agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$monitori2 = agentPolicy.monitoring_enabled) === null || _agentPolicy$monitori2 === void 0 ? void 0 : _agentPolicy$monitori2.length) !== null && _agentPolicy$monitori !== void 0 ? _agentPolicy$monitori : 0 > 0;
  const buttonArgs = !isInstalled || isLoading || !isLogAndMetricsEnabled ? {
    disabled: true
  } : {
    href: link
  };
  const button = /*#__PURE__*/_react.default.createElement(EuiButtonCompressed, (0, _extends2.default)({}, buttonArgs, {
    isLoading: isLoading,
    color: "primary",
    iconType: "dashboardApp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "agentDetails.viewMoreMetricsButton",
    id: "xpack.fleet.agentDetails.viewDashboardButtonLabel",
    defaultMessage: "View more agent metrics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
  if (!isLoading && !isLogAndMetricsEnabled && agentPolicy) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetails.viewDashboardButton.disabledNoLogsAndMetricsTooltip",
        defaultMessage: "Logs and metrics for agent are not enabled in the agent policy.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(EuiButtonCompressed, {
      "data-test-subj": "agentDetails.enableLogsAndMetricsButton",
      isLoading: isLoading,
      color: "primary",
      href: getHref('policy_details', {
        policyId: agentPolicy.id,
        tabId: 'settings'
      }),
      disabled: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.enableLogsAndMetricsLabel",
      defaultMessage: "Enable logs and metrics",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    })));
  }
  if (!isInstalled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetails.viewDashboardButton.disabledNoIntegrationTooltip",
        defaultMessage: "Agent dashboard not found, you need to install the elastic_agent integration.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, button);
  }
  return button;
};
exports.AgentDashboardLink = AgentDashboardLink;