"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _file_kinds_registry = require("../common/file_kinds_registry");
var _files_client = require("./files_client");
var DefaultImageFileKind = _interopRequireWildcard(require("../common/default_image_file_kind"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Public setup-phase contract
 */

/**
 * Bringing files to Kibana
 */
class FilesPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "registry", new _file_kinds_registry.FileKindsRegistryImpl());
    (0, _defineProperty2.default)(this, "filesClientFactory", void 0);
  }
  setup(core) {
    this.registry.register({
      ...DefaultImageFileKind.kind,
      maxSizeBytes: DefaultImageFileKind.maxSize
    });
    this.filesClientFactory = {
      asScoped: fileKind => {
        return (0, _files_client.createFilesClient)({
          registry: this.registry,
          fileKind,
          http: core.http
        });
      },
      asUnscoped: () => {
        return (0, _files_client.createFilesClient)({
          registry: this.registry,
          http: core.http
        });
      }
    };
    return {
      filesClientFactory: this.filesClientFactory,
      registerFileKind: fileKind => {
        this.registry.register(fileKind);
      }
    };
  }
  start(core) {
    return {
      filesClientFactory: this.filesClientFactory,
      getFileKindDefinition: id => {
        return this.registry.get(id);
      },
      getAllFindKindDefinitions: () => {
        return this.registry.getAll();
      }
    };
  }
}
exports.FilesPlugin = FilesPlugin;