"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsFieldsRepository = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _PathReporter = require("io-ts/PathReporter");
var _lodash = require("lodash");
var _Either = require("fp-ts/Either");
var _fields_metadata = require("../../../../common/fields_metadata");
var _fields_metadata_dictionary = require("../../../../common/fields_metadata/models/fields_metadata_dictionary");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EcsFieldsRepository {
  constructor(ecsFields) {
    (0, _defineProperty2.default)(this, "ecsFields", void 0);
    this.ecsFields = (0, _lodash.mapValues)(ecsFields, field => _common.FieldMetadata.create({
      ...field,
      source: 'ecs'
    }));
  }
  getByName(fieldName) {
    return this.ecsFields[fieldName];
  }
  find({
    fieldNames
  } = {}) {
    if (!fieldNames) {
      return _fields_metadata_dictionary.FieldsMetadataDictionary.create(this.ecsFields);
    }
    const fields = fieldNames.reduce((fieldsMetadata, fieldName) => {
      const field = this.getByName(fieldName);
      if (field) {
        fieldsMetadata[fieldName] = field;
      }
      return fieldsMetadata;
    }, {});
    return _fields_metadata_dictionary.FieldsMetadataDictionary.create(fields);
  }
  static create({
    ecsFields
  }) {
    const decodedFields = _fields_metadata.fieldsMetadataDictionaryRT.decode(ecsFields);
    if ((0, _Either.isLeft)(decodedFields)) {
      throw Error(`EcsFieldsRepositoryDeps.create: could not validate data: ${_PathReporter.PathReporter.report(decodedFields).join('\n')}`);
    }
    return new EcsFieldsRepository(decodedFields.right);
  }
}
exports.EcsFieldsRepository = EcsFieldsRepository;