"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateFormat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _fieldTypes = require("@kbn/field-types");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DateFormat extends _common.FieldFormat {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "memoizedConverter", _lodash.noop);
    (0, _defineProperty2.default)(this, "memoizedPattern", '');
    (0, _defineProperty2.default)(this, "timeZone", '');
    (0, _defineProperty2.default)(this, "textConvert", val => {
      // don't give away our ref to converter so
      // we can hot-swap when config changes
      const pattern = this.param('pattern');
      const timezone = this.param('timezone');
      const timezoneChanged = this.timeZone !== timezone;
      const datePatternChanged = this.memoizedPattern !== pattern;
      if (timezoneChanged || datePatternChanged) {
        this.timeZone = timezone;
        this.memoizedPattern = pattern;
        this.memoizedConverter = (0, _lodash.memoize)(function converter(value) {
          if (value === null || value === undefined) {
            return '-';
          }
          const date = (0, _moment.default)(value);
          if (date.isValid()) {
            return date.locale(_i18n.i18n.getLocale()).format(pattern);
          } else {
            return value;
          }
        });
      }
      return this.memoizedConverter(val);
    });
  }
  getParamDefaults() {
    return {
      pattern: this.getConfig('dateFormat'),
      timezone: this.getConfig('dateFormat:tz')
    };
  }
}
exports.DateFormat = DateFormat;
(0, _defineProperty2.default)(DateFormat, "id", _common.FIELD_FORMAT_IDS.DATE);
(0, _defineProperty2.default)(DateFormat, "title", _i18n.i18n.translate('fieldFormats.date.title', {
  defaultMessage: 'Date'
}));
(0, _defineProperty2.default)(DateFormat, "fieldType", _fieldTypes.KBN_FIELD_TYPES.DATE);