"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getXDomain = exports.getAppliedTimeRange = exports.XyEndzones = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _public = require("@kbn/charts-plugin/public");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/x_domain.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getAppliedTimeRange = (datatableUtilitites, layers) => {
  return layers.map(({
    xAccessor,
    table
  }) => {
    var _datatableUtilitites$;
    const xColumn = xAccessor ? (0, _utils.getColumnByAccessor)(xAccessor, table.columns) : null;
    const timeRange = xColumn && ((_datatableUtilitites$ = datatableUtilitites.getDateHistogramMeta(xColumn)) === null || _datatableUtilitites$ === void 0 ? void 0 : _datatableUtilitites$.timeRange);
    if (timeRange) {
      return {
        timeRange,
        field: xColumn === null || xColumn === void 0 ? void 0 : xColumn.meta.field
      };
    }
  }).find(Boolean);
};
exports.getAppliedTimeRange = getAppliedTimeRange;
const getXDomain = (datatableUtilitites, layers, minInterval, isTimeViz, isHistogram, hasBars, timeZone, xExtent) => {
  var _getAppliedTimeRange;
  const appliedTimeRange = (_getAppliedTimeRange = getAppliedTimeRange(datatableUtilitites, layers)) === null || _getAppliedTimeRange === void 0 ? void 0 : _getAppliedTimeRange.timeRange;
  const from = appliedTimeRange === null || appliedTimeRange === void 0 ? void 0 : appliedTimeRange.from;
  const to = appliedTimeRange === null || appliedTimeRange === void 0 ? void 0 : appliedTimeRange.to;
  const baseDomain = isTimeViz ? {
    min: from ? (0, _moment.default)(from).valueOf() : NaN,
    max: to ? (0, _moment.default)(to).valueOf() : NaN,
    minInterval
  } : isHistogram ? {
    minInterval,
    min: NaN,
    max: NaN
  } : undefined;
  if ((isHistogram || isTimeViz) && isFullyQualified(baseDomain)) {
    if (xExtent && !isTimeViz) {
      var _xExtent$lowerBound, _xExtent$upperBound;
      return {
        extendedDomain: {
          min: (_xExtent$lowerBound = xExtent.lowerBound) !== null && _xExtent$lowerBound !== void 0 ? _xExtent$lowerBound : NaN,
          max: (_xExtent$upperBound = xExtent.upperBound) !== null && _xExtent$upperBound !== void 0 ? _xExtent$upperBound : NaN,
          minInterval: baseDomain.minInterval
        },
        baseDomain
      };
    }
    const xValues = (0, _lodash.uniq)(layers.flatMap(({
      table,
      xAccessor
    }) => {
      const accessor = xAccessor !== undefined ? (0, _utils.getAccessorByDimension)(xAccessor, table.columns) : undefined;
      return table.rows.map(row => accessor && row[accessor] && row[accessor].valueOf());
    }).filter(v => !(0, _lodash.isUndefined)(v)).sort());
    const [firstXValue] = xValues;
    const lastXValue = xValues[xValues.length - 1];
    const domainMin = Math.min(firstXValue, baseDomain.min);
    const domainMaxValue = Math.max(baseDomain.max - baseDomain.minInterval, lastXValue);
    const domainMax = hasBars ? domainMaxValue : domainMaxValue + baseDomain.minInterval;
    const duration = _moment.default.duration(baseDomain.minInterval);
    const selectedUnit = (0, _lodash.find)(_datemath.default.units, u => {
      const value = duration.as(u);
      return Number.isInteger(value);
    });
    return {
      extendedDomain: {
        min: domainMin,
        max: domainMax,
        minInterval: (0, _public.getAdjustedInterval)(xValues, duration.as(selectedUnit), selectedUnit, timeZone)
      },
      baseDomain
    };
  }
  return {
    baseDomain,
    extendedDomain: baseDomain
  };
};
exports.getXDomain = getXDomain;
function isFullyQualified(xDomain) {
  return Boolean(xDomain && typeof xDomain.min === 'number' && typeof xDomain.max === 'number' && xDomain.minInterval);
}
const XyEndzones = function ({
  baseDomain,
  extendedDomain,
  histogramMode,
  darkMode
}) {
  return isFullyQualified(baseDomain) && isFullyQualified(extendedDomain) ? /*#__PURE__*/_react.default.createElement(_public.Endzones, {
    isFullBin: !histogramMode,
    isDarkMode: darkMode,
    domainStart: baseDomain.min,
    domainEnd: baseDomain.max,
    interval: extendedDomain.minInterval,
    domainMin: extendedDomain.min,
    domainMax: extendedDomain.max,
    hideTooltips: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }) : null;
};
exports.XyEndzones = XyEndzones;