"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDistributionInPercentageColumn = getDistributionInPercentageColumn;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDistributionInPercentageColumn({
  label,
  layerId,
  dataView,
  columnFilter,
  formula,
  format
}) {
  let lensFormula = formula !== null && formula !== void 0 ? formula : 'count() / overall_sum(count())';
  if (columnFilter) {
    lensFormula = formula !== null && formula !== void 0 ? formula : `count(kql='${columnFilter}') / overall_sum(count(kql='${columnFilter}'))`;
  }
  return {
    dataType: 'number',
    isBucketed: false,
    label: label !== null && label !== void 0 ? label : '',
    customLabel: label != null,
    operationType: 'formula',
    params: {
      formula: lensFormula,
      isFormulaBroken: false,
      format: format === 'percent' || !format ? {
        id: 'percent',
        params: {
          decimals: 0
        }
      } : undefined
    },
    references: []
  };
}