"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventAnnotationService = getEventAnnotationService;
exports.hasIcon = hasIcon;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/data-views-plugin/common");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _event_annotation_group_saved_object_finder = require("../components/event_annotation_group_saved_object_finder");
var _content_management = require("../../common/content_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/event_annotation/public/event_annotation_service/service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function hasIcon(icon) {
  return icon != null && icon !== 'empty';
}
function getEventAnnotationService(core, contentManagement) {
  const client = contentManagement.client;
  const mapSavedObjectToGroupConfig = savedObject => {
    var _savedObject$referenc;
    const adHocDataViewSpec = savedObject.attributes.dataViewSpec ? _common2.DataViewPersistableStateService.inject(savedObject.attributes.dataViewSpec, savedObject.references) : undefined;
    return {
      title: savedObject.attributes.title,
      description: savedObject.attributes.description,
      tags: savedObject.references.filter(ref => ref.type === 'tag').map(({
        id
      }) => id),
      ignoreGlobalFilters: savedObject.attributes.ignoreGlobalFilters,
      indexPatternId: adHocDataViewSpec ? adHocDataViewSpec.id : (_savedObject$referenc = savedObject.references.find(ref => ref.type === 'index-pattern')) === null || _savedObject$referenc === void 0 ? void 0 : _savedObject$referenc.id,
      annotations: savedObject.attributes.annotations,
      dataViewSpec: adHocDataViewSpec
    };
  };
  const mapSavedObjectToGroupContent = savedObject => {
    const groupConfig = mapSavedObjectToGroupConfig(savedObject);
    return {
      id: savedObject.id,
      references: savedObject.references,
      type: savedObject.type,
      updatedAt: savedObject.updatedAt ? savedObject.updatedAt : '',
      attributes: {
        title: groupConfig.title,
        description: groupConfig.description,
        indexPatternId: groupConfig.indexPatternId,
        dataViewSpec: groupConfig.dataViewSpec
      }
    };
  };
  const loadAnnotationGroup = async savedObjectId => {
    const savedObject = await client.get({
      contentTypeId: _content_management.CONTENT_ID,
      id: savedObjectId
    });
    if (savedObject.item.error) {
      throw savedObject.item.error;
    }
    return mapSavedObjectToGroupConfig(savedObject.item);
  };
  const groupExistsWithTitle = async title => {
    const {
      hits
    } = await client.search({
      contentTypeId: _content_management.CONTENT_ID,
      query: {
        text: title
      },
      options: {
        searchFields: ['title']
      }
    });
    for (const hit of hits) {
      if (hit.attributes.title.toLowerCase() === title.toLowerCase()) {
        return true;
      }
    }
    return false;
  };
  const findAnnotationGroupContent = async (searchTerm, pageSize, tagsToInclude, tagsToExclude) => {
    const {
      pagination,
      hits
    } = await client.search({
      contentTypeId: _content_management.CONTENT_ID,
      query: {
        text: searchTerm ? `${searchTerm}*` : undefined,
        limit: pageSize,
        tags: {
          included: tagsToInclude,
          excluded: tagsToExclude
        }
      }
    });
    return {
      total: pagination.total,
      hits: hits.map(mapSavedObjectToGroupContent)
    };
  };
  const deleteAnnotationGroups = async ids => {
    for (const id of ids) {
      await client.delete({
        contentTypeId: _content_management.CONTENT_ID,
        id
      });
    }
  };
  const extractDataViewInformation = group => {
    let {
      dataViewSpec = null
    } = group;
    let references;
    if (dataViewSpec) {
      if (!dataViewSpec.id) throw new Error('tried to create annotation group with a data view spec that did not include an ID!');
      const {
        state,
        references: refsFromDataView
      } = _common2.DataViewPersistableStateService.extract(dataViewSpec);
      dataViewSpec = state;
      references = refsFromDataView;
    } else {
      references = [{
        type: 'index-pattern',
        id: group.indexPatternId,
        name: `event-annotation-group_dataView-ref-${group.indexPatternId}`
      }];
    }
    return {
      references,
      dataViewSpec
    };
  };
  const getAnnotationGroupAttributesAndReferences = group => {
    const {
      references,
      dataViewSpec
    } = extractDataViewInformation(group);
    const {
      title,
      description,
      tags,
      ignoreGlobalFilters,
      annotations
    } = group;
    references.push(...tags.map(tag => ({
      id: tag,
      name: tag,
      type: 'tag'
    })));
    return {
      attributes: {
        title,
        description,
        ignoreGlobalFilters,
        annotations,
        dataViewSpec
      },
      references
    };
  };
  const createAnnotationGroup = async group => {
    const {
      attributes,
      references
    } = getAnnotationGroupAttributesAndReferences(group);
    const groupSavedObjectId = (await client.create({
      contentTypeId: _content_management.CONTENT_ID,
      data: {
        ...attributes
      },
      options: {
        references
      }
    })).item.id;
    return {
      id: groupSavedObjectId
    };
  };
  const updateAnnotationGroup = async (group, annotationGroupId) => {
    const {
      attributes,
      references
    } = getAnnotationGroupAttributesAndReferences(group);
    await client.update({
      contentTypeId: _content_management.CONTENT_ID,
      id: annotationGroupId,
      data: {
        ...attributes
      },
      options: {
        references
      }
    });
  };
  const checkHasAnnotationGroups = async () => {
    const response = await client.search({
      contentTypeId: _content_management.CONTENT_ID,
      query: {
        text: '*'
      }
    });
    return response.pagination.total > 0;
  };
  return {
    loadAnnotationGroup,
    groupExistsWithTitle,
    updateAnnotationGroup,
    createAnnotationGroup,
    deleteAnnotationGroups,
    findAnnotationGroupContent,
    renderEventAnnotationGroupSavedObjectFinder: props => {
      return /*#__PURE__*/_react.default.createElement(_event_annotation_group_saved_object_finder.EventAnnotationGroupSavedObjectFinder, (0, _extends2.default)({
        contentClient: contentManagement.client,
        uiSettings: core.uiSettings,
        checkHasAnnotationGroups: checkHasAnnotationGroups
      }, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 290,
          columnNumber: 9
        }
      }));
    },
    toExpression: annotationsToExpression,
    toFetchExpression: ({
      interval,
      groups
    }) => {
      if (groups.length === 0) {
        return [];
      }
      const groupsExpressions = groups.filter(g => g.annotations.some(a => !a.isHidden)).map(({
        annotations,
        indexPatternId,
        ignoreGlobalFilters
      }) => {
        const indexPatternExpression = {
          type: 'expression',
          chain: [{
            type: 'function',
            function: 'indexPatternLoad',
            arguments: {
              id: [indexPatternId]
            }
          }]
        };
        const annotationExpressions = annotationsToExpression(annotations);
        return {
          type: 'expression',
          chain: [{
            type: 'function',
            function: 'event_annotation_group',
            arguments: {
              dataView: [indexPatternExpression],
              annotations: [...annotationExpressions],
              ignoreGlobalFilters: [Boolean(ignoreGlobalFilters)]
            }
          }]
        };
      });
      const fetchExpression = {
        type: 'expression',
        chain: [{
          type: 'function',
          function: 'kibana',
          arguments: {}
        }, {
          type: 'function',
          function: 'fetch_event_annotations',
          arguments: {
            interval: [interval],
            groups: [...groupsExpressions]
          }
        }]
      };
      return [fetchExpression];
    }
  };
}
const annotationsToExpression = annotations => {
  const [queryBasedAnnotations, manualBasedAnnotations] = (0, _lodash.partition)(annotations, _eventAnnotationCommon.isQueryAnnotationConfig);
  const expressions = [];
  for (const annotation of manualBasedAnnotations) {
    if ((0, _eventAnnotationCommon.isRangeAnnotationConfig)(annotation)) {
      const {
        label,
        color,
        key,
        outside,
        id
      } = annotation;
      const {
        timestamp: time,
        endTimestamp: endTime
      } = key;
      expressions.push({
        type: 'expression',
        chain: [{
          type: 'function',
          function: 'manual_range_event_annotation',
          arguments: {
            id: [id],
            time: [time],
            endTime: [endTime],
            label: [label || _eventAnnotationCommon.defaultAnnotationLabel],
            color: [color || _eventAnnotationCommon.defaultAnnotationRangeColor],
            outside: [Boolean(outside)],
            isHidden: [Boolean(annotation.isHidden)]
          }
        }]
      });
    } else {
      const {
        label,
        color,
        lineStyle,
        lineWidth,
        icon,
        key,
        textVisibility,
        id
      } = annotation;
      expressions.push({
        type: 'expression',
        chain: [{
          type: 'function',
          function: 'manual_point_event_annotation',
          arguments: {
            id: [id],
            time: [key.timestamp],
            label: [label || _eventAnnotationCommon.defaultAnnotationLabel],
            color: [color || _eventAnnotationCommon.defaultAnnotationColor],
            lineWidth: [lineWidth || 1],
            lineStyle: [lineStyle || 'solid'],
            icon: hasIcon(icon) ? [icon] : ['triangle'],
            textVisibility: [textVisibility || false],
            isHidden: [Boolean(annotation.isHidden)]
          }
        }]
      });
    }
  }
  for (const annotation of queryBasedAnnotations) {
    const {
      id,
      label,
      color,
      lineStyle,
      lineWidth,
      icon,
      timeField,
      textVisibility,
      textField,
      filter,
      extraFields
    } = annotation;
    expressions.push({
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'query_point_event_annotation',
        arguments: {
          id: [id],
          timeField: timeField ? [timeField] : [],
          label: [label || _eventAnnotationCommon.defaultAnnotationLabel],
          color: [color || _eventAnnotationCommon.defaultAnnotationColor],
          lineWidth: [lineWidth || 1],
          lineStyle: [lineStyle || 'solid'],
          icon: hasIcon(icon) ? [icon] : ['triangle'],
          textVisibility: [textVisibility || false],
          textField: textVisibility && textField ? [textField] : [],
          filter: filter ? [(0, _common.queryToAst)(filter)] : [],
          extraFields: extraFields || [],
          isHidden: [Boolean(annotation.isHidden)]
        }
      }]
    });
  }
  return expressions;
};