"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.command = exports.cmd = void 0;
var _parser = require("../parser");
var _tag = require("./tag");
var _synth_node = require("./synth_node");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generator = (src, {
  withFormatting = true,
  ...rest
} = {}) => {
  src = src.trimStart();
  const {
    root
  } = _parser.Parser.parseCommand(src, {
    withFormatting,
    ...rest
  });
  if (root.type !== 'command') {
    throw new Error('Expected a command node');
  }
  const node = _synth_node.SynthNode.from(root);
  return node;
};
const command = exports.command = (0, _tag.createTag)(generator);

/**
 * Short 3-letter alias for DX convenience.
 */
const cmd = exports.cmd = command;