"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mvExpandCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mvExpandCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  validate: _validate.validate
};
const mvExpandCommand = exports.mvExpandCommand = {
  name: 'mv_expand',
  methods: mvExpandCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.mvExpandDoc', {
      defaultMessage: 'Expands multivalued fields into one row per value, duplicating other fields'
    }),
    declaration: 'MV_EXPAND column',
    examples: ['ROW a=[1,2,3] | MV_EXPAND a'],
    preview: true
  }
};