"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inlineStatsCommand = void 0;
var _i18n = require("@kbn/i18n");
var _columns_after = require("./columns_after");
var _autocomplete = require("./autocomplete");
var _validate = require("../stats/validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const inlineStatsCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  validate: _validate.validate,
  columnsAfter: _columns_after.columnsAfter
};
const inlineStatsCommand = exports.inlineStatsCommand = {
  name: 'inline stats',
  methods: inlineStatsCommandMethods,
  metadata: {
    hidden: false,
    preview: true,
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.inlineStatsDoc', {
      defaultMessage: 'Unlike STATS, INLINE STATS preserves all columns from the previous pipe and returns them together with the new aggregate columns.'
    }),
    declaration: `INLINE STATS [column1 =] expression1 [WHERE boolean_expression1][,
...,
[columnN =] expressionN [WHERE boolean_expressionN]]
[BY grouping_expression1[, ..., grouping_expressionN]]`,
    examples: ['… | INLINE STATS avg = avg(a)', '… | INLINE STATS sum(b) BY b', '… | INLINE STATS sum(b) BY b % 2']
  }
};