"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asSuggestion = exports.Position = void 0;
exports.autocomplete = autocomplete;
exports.onSuggestion = exports.getPosition = void 0;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _types = require("../../../definitions/types");
var _complete_items = require("../../complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let Position = exports.Position = /*#__PURE__*/function (Position) {
  Position["VALUE"] = "value";
  Position["AFTER_VALUE"] = "after_value";
  Position["ON_COLUMN"] = "on_column";
  Position["AFTER_ON_CLAUSE"] = "after_on_clause";
  Position["AS_TYPE_COLUMN"] = "as_type_clause";
  Position["AS_P_VALUE_COLUMN"] = "as_p_value_column";
  Position["AFTER_AS_CLAUSE"] = "after_as_clause";
  return Position;
}({});
const getPosition = (query, command) => {
  if (command.args.length < 2) {
    if (query.match(/CHANGE_POINT\s+\S*$/i)) {
      return Position.VALUE;
    }
    if (query.match(/CHANGE_POINT\s+\S+\s*\S*$/i)) {
      return Position.AFTER_VALUE;
    }
  }
  const lastArg = command.args[command.args.length - 1];
  if (query.match(/on\s+\S*$/i)) {
    return Position.ON_COLUMN;
  }
  if (!Array.isArray(lastArg) && lastArg.name === 'on') {
    if (query.match(/on\s+\S+\s+$/i)) {
      return Position.AFTER_ON_CLAUSE;
    }
  }
  if (query.match(/as\s+$/i)) {
    return Position.AS_TYPE_COLUMN;
  }
  if (!Array.isArray(lastArg) && lastArg.name === 'as') {
    if (query.match(/as\s+\S+,\s*\S*$/i)) {
      return Position.AS_P_VALUE_COLUMN;
    }
    if (query.match(/as\s+\S+,\s*\S+\s+$/i)) {
      return Position.AFTER_AS_CLAUSE;
    }
  }
};
exports.getPosition = getPosition;
const onSuggestion = exports.onSuggestion = (0, _helpers.withAutoSuggest)({
  label: 'ON',
  text: 'ON ',
  kind: 'Reference',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.onDoc', {
    defaultMessage: 'On'
  }),
  sortText: '1'
});
const asSuggestion = exports.asSuggestion = (0, _helpers.withAutoSuggest)({
  label: 'AS',
  text: 'AS ',
  kind: 'Reference',
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.asDoc', {
    defaultMessage: 'As'
  }),
  sortText: '2'
});
async function autocomplete(query, command, callbacks, context, cursorPosition) {
  var _await$callbacks$getB, _callbacks$getByType;
  const innerText = query.substring(0, cursorPosition);
  const pos = getPosition(innerText, command);
  switch (pos) {
    case Position.VALUE:
      const numericFields = (_await$callbacks$getB = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, _types.ESQL_NUMBER_TYPES, [], {
        advanceCursor: true,
        openSuggestions: true
      }))) !== null && _await$callbacks$getB !== void 0 ? _await$callbacks$getB : [];
      const lastWord = (0, _helpers.findFinalWord)(innerText);
      if (lastWord !== '') {
        numericFields.forEach(fieldSuggestion => {
          fieldSuggestion.rangeToReplace = {
            start: innerText.length - lastWord.length + 1,
            end: innerText.length + 1
          };
        });
      }
      return numericFields;
    case Position.AFTER_VALUE:
      {
        return [onSuggestion, asSuggestion, _complete_items.pipeCompleteItem];
      }
    case Position.ON_COLUMN:
      {
        var _await$callbacks$getB2, _callbacks$getByType2;
        const onFields = (_await$callbacks$getB2 = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType2 = callbacks.getByType) === null || _callbacks$getByType2 === void 0 ? void 0 : _callbacks$getByType2.call(callbacks, 'any', [], {
          advanceCursor: true,
          openSuggestions: true
        }))) !== null && _await$callbacks$getB2 !== void 0 ? _await$callbacks$getB2 : [];
        return onFields;
      }
    case Position.AFTER_ON_CLAUSE:
      return [asSuggestion, _complete_items.pipeCompleteItem];
    case Position.AS_TYPE_COLUMN:
      {
        // add comma and space
        return (0, _helpers.buildUserDefinedColumnsDefinitions)(['changePointType']).map(v => (0, _helpers.withAutoSuggest)({
          ...v,
          text: v.text + ', '
        }));
      }
    case Position.AS_P_VALUE_COLUMN:
      {
        return (0, _helpers.buildUserDefinedColumnsDefinitions)(['pValue']).map(v => (0, _helpers.withAutoSuggest)(v));
      }
    case Position.AFTER_AS_CLAUSE:
      {
        return [_complete_items.pipeCompleteItem];
      }
    default:
      return [];
  }
}