"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reorder = Reorder;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _components = require("../../../components");
var _helpers = require("../../../helpers");
var _use_field = require("../use_field");
var _use_array = require("../use_array");
var _form_utils = require("./form_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/use_array_reorder.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const {
  emptyField
} = _helpers.fieldValidators;
const defaultValue = {
  employees: [{
    name: 'John',
    lastName: 'Snow'
  }, {
    name: 'Mick',
    lastName: 'Jagger'
  }, {
    name: 'Roger',
    lastName: 'Federer'
  }]
};
const formConfig = {
  defaultValue
};
function Reorder() {
  return /*#__PURE__*/_react.default.createElement(_form_utils.FormWrapper, {
    formConfig: formConfig,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, "Employees")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_use_array.UseArray, {
    path: "employees",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, ({
    items,
    addItem,
    removeItem,
    moveItem
  }) => {
    const onDragEnd = ({
      source,
      destination
    }) => {
      if (source && destination) {
        moveItem(source.index, destination.index);
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
      onDragEnd: onDragEnd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: "1",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(({
      id,
      path
    }, index) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
        spacing: "none",
        draggableId: String(id),
        index: index,
        key: id,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 27
        }
      }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        key: id,
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 31
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 33
        }
      }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, provided.dragHandleProps, {
        css: {
          marginTop: '20px'
        },
        "aria-label": "Change row order",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 35
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "grab",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 37
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 33
        }
      }, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
        path: `${path}.name`,
        config: {
          label: 'Name',
          validations: [{
            validator: emptyField('A name is required.')
          }]
        },
        component: _components.TextField,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 35
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 33
        }
      }, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
        path: `${path}.lastName`,
        config: {
          label: 'Last name',
          validations: [{
            validator: emptyField('A last name is required.')
          }]
        },
        component: _components.TextField,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 35
        }
      })), items.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 35
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "minusInCircle",
        onClick: () => removeItem(id),
        "aria-label": "Remove item",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 37
        }
      }))));
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: addItem,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 19
      }
    }, "Add employee")));
  })));
}
Reorder.storyName = 'Reorder';
Reorder.parameters = {
  docs: {
    source: {
      code: `
const defaultValue = {
  employees: [
    {
      name: 'John',
      lastName: 'Snow',
    },
    {
      name: 'Mick',
      lastName: 'Jagger',
    },
    {
      name: 'Roger',
      lastName: 'Federer',
    },
  ],
};

const MyFormComponent = () => {
  const { form } = useForm({ defaultValue });

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiTitle>
        <h2>Employees</h2>
      </EuiTitle>
      <EuiSpacer />

      <UseArray path="employees">
        {({ items, addItem, removeItem, moveItem }) => {
          const onDragEnd = ({ source, destination }: DropResult) => {
            if (source && destination) {
              moveItem(source.index, destination.index);
            }
          };

          return (
            <>
              <EuiDragDropContext onDragEnd={onDragEnd}>
                <EuiDroppable droppableId="1">
                  <>
                    {items.map(({ id, path }, index) => {
                      return (
                        <EuiDraggable
                          spacing="none"
                          draggableId={String(id)}
                          index={index}
                          key={id}
                        >
                          {(provided) => (
                            <EuiFlexGroup key={id} alignItems="center">
                              <EuiFlexItem grow={false}>
                                <div
                                  {...provided.dragHandleProps}
                                  css={{ marginTop: '20px' }}
                                  aria-label="Change row order"
                                >
                                  <EuiIcon type="grab" />
                                </div>
                              </EuiFlexItem>
                              <EuiFlexItem>
                                <UseField
                                  path={\`\${path}.name\`}
                                  config={{
                                    label: 'Name',
                                    validations: [
                                      { validator: emptyField('A name is required.') },
                                    ],
                                  }}
                                  component={TextField}
                                />
                              </EuiFlexItem>
                              <EuiFlexItem>
                                <UseField
                                  path={\`\${path}.lastName\`}
                                  config={{
                                    label: 'Last name',
                                    validations: [
                                      { validator: emptyField('A last name is required.') },
                                    ],
                                  }}
                                  component={TextField}
                                />
                              </EuiFlexItem>
                              {items.length > 1 && (
                                <EuiFlexItem grow={false}>
                                  <EuiButtonIcon
                                    iconType="minusInCircle"
                                    onClick={() => removeItem(id)}
                                    aria-label="Remove item"
                                  />
                                </EuiFlexItem>
                              )}
                            </EuiFlexGroup>
                          )}
                        </EuiDraggable>
                      );
                    })}
                  </>
                </EuiDroppable>
              </EuiDragDropContext>

              <EuiSpacer size="m" />
              <EuiFlexGroup justifyContent="flexEnd">
                <EuiButtonEmpty onClick={addItem}>Add employee</EuiButtonEmpty>
              </EuiFlexGroup>
            </>
          );
        }}
      </UseArray>
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
}
      `,
      language: 'tsx'
    }
  }
};