"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalFlyout = exports.GlobalFlyoutProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/es_ui_shared/__packages_do_not_import__/global_flyout/global_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutMultiContentContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const DEFAULT_FLYOUT_PROPS = {
  'data-test-subj': 'flyout',
  size: 'm',
  maxWidth: 500
};
const GlobalFlyoutProvider = ({
  children
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [activeContent, setActiveContent] = (0, _react.useState)(undefined);
  const {
    id,
    Component,
    props,
    flyoutProps,
    cleanUpFunc
  } = activeContent !== null && activeContent !== void 0 ? activeContent : {};
  const addContent = (0, _react.useCallback)(content => {
    setActiveContent(prev => {
      if (prev !== undefined) {
        if (prev.id !== content.id && prev.cleanUpFunc) {
          // Clean up anything from the content about to be removed
          prev.cleanUpFunc();
        }
      }
      return content;
    });
    setShowFlyout(true);
  }, []);
  const closeFlyout = (0, _react.useCallback)(() => {
    setActiveContent(undefined);
    setShowFlyout(false);
  }, []);
  const removeContent = (0, _react.useCallback)(contentId => {
    // Note: when we will actually deal with multi content then
    // there will be more logic here! :)
    if (contentId === id) {
      setActiveContent(undefined);
      if (cleanUpFunc) {
        cleanUpFunc();
      }
      closeFlyout();
    }
  }, [id, closeFlyout, cleanUpFunc]);
  const mergedFlyoutProps = (0, _react.useMemo)(() => {
    return {
      ...DEFAULT_FLYOUT_PROPS,
      onClose: closeFlyout,
      ...flyoutProps
    };
  }, [flyoutProps, closeFlyout]);
  const context = {
    addContent,
    removeContent,
    closeFlyout
  };
  const ContentFlyout = showFlyout && Component !== undefined ? Component : null;
  return /*#__PURE__*/_react.default.createElement(FlyoutMultiContentContext.Provider, {
    value: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, ContentFlyout && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({}, mergedFlyoutProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(ContentFlyout, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  })))));
};
exports.GlobalFlyoutProvider = GlobalFlyoutProvider;
const useGlobalFlyout = () => {
  const ctx = (0, _react.useContext)(FlyoutMultiContentContext);
  if (ctx === undefined) {
    throw new Error('useGlobalFlyout must be used within a <GlobalFlyoutProvider />');
  }
  const isMounted = (0, _react.useRef)(false);
  /**
   * A component can add one or multiple content to the flyout
   * during its lifecycle. When it unmounts, we will remove
   * all those content added to the flyout.
   */
  const contents = (0, _react.useRef)(undefined);
  const {
    removeContent,
    addContent: addContentToContext
  } = ctx;
  const getContents = (0, _react.useCallback)(() => {
    if (contents.current === undefined) {
      contents.current = new Set();
    }
    return contents.current;
  }, []);
  const addContent = (0, _react.useCallback)(content => {
    getContents().add(content.id);
    return addContentToContext(content);
  }, [getContents, addContentToContext]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    return () => {
      if (!isMounted.current) {
        // When the component unmounts, remove all the content it has added to the flyout
        Array.from(getContents()).forEach(removeContent);
      }
    };
  }, [removeContent, getContents]);
  return {
    ...ctx,
    addContent
  };
};
exports.useGlobalFlyout = useGlobalFlyout;