"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageError = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _coreApplicationCommon = require("@kbn/core-application-common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/es_ui_shared/__packages_do_not_import__/authorization/components/page_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/*
 * A reusable component to handle full page errors.
 * This is based on Kibana design guidelines related
 * to the new management navigation structure.
 * In some scenarios, it replaces the usage of <SectionError />.
 */

const PageError = ({
  title,
  error,
  actions,
  isCentered,
  ...rest
}) => {
  const errorString = error === null || error === void 0 ? void 0 : error.error;
  const cause = error === null || error === void 0 ? void 0 : error.cause; // wrapEsError() on the server adds a "cause" array
  const message = error === null || error === void 0 ? void 0 : error.message;
  const errorContent = /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, (0, _extends2.default)({
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 14
      }
    }, title),
    body: error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cause ? message || errorString : /*#__PURE__*/_react.default.createElement("p", {
      className: "eui-textBreakWord",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 15
      }
    }, message || errorString), cause && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 17
      }
    }, cause.map((causeMsg, i) => /*#__PURE__*/_react.default.createElement("li", {
      key: i,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 21
      }
    }, causeMsg))))),
    iconType: "warning",
    color: "danger",
    actions: actions
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }));
  if (isCentered) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: _coreApplicationCommon.APP_WRAPPER_CLASS,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 12
      }
    }, errorContent);
  }
  return errorContent;
};
exports.PageError = PageError;