"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchUnattachedIndices = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _is_not_nullish = require("../../../common/utils/is_not_nullish");
var _get_index_data = require("./utils/get_index_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchUnattachedIndices = async (client, searchQuery, from, size) => {
  const {
    indexNames
  } = await (0, _get_index_data.getUnattachedIndexData)(client, searchQuery);
  let connectors = [];
  try {
    connectors = await (0, _searchConnectors.fetchConnectors)(client.asCurrentUser, indexNames);
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
  } catch (error) {
    connectors = [];
  }
  const connectedIndexNames = [...connectors.map(con => con.index_name).filter(_is_not_nullish.isNotNullish)];
  const indexNameSlice = indexNames.filter(indexName => !connectedIndexNames.includes(indexName)).filter(_is_not_nullish.isNotNullish).slice(from, from + size);
  if (indexNameSlice.length === 0) {
    return {
      indexNames: [],
      totalResults: indexNames.length
    };
  }
  return {
    indexNames: indexNameSlice,
    totalResults: indexNames.length
  };
};
exports.fetchUnattachedIndices = fetchUnattachedIndices;