"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEnterpriseSearchIntegrations = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerEnterpriseSearchIntegrations = (config, customIntegrations, crawlerAssetBasePath) => {
  if (config.hasWebCrawler) {
    customIntegrations.registerCustomIntegration({
      id: 'web_crawler',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.integrations.webCrawlerName', {
        defaultMessage: 'Web Crawler'
      }),
      description: _i18n.i18n.translate('xpack.enterpriseSearch.integrations.webCrawlerDescription', {
        defaultMessage: 'Add search to your website with the web crawler.'
      }),
      categories: ['search', 'web', 'elastic_stack', 'crawler'],
      uiInternalPath: '/app/elasticsearch/content/crawlers',
      icons: [{
        type: 'svg',
        src: crawlerAssetBasePath
      }],
      shipper: 'search',
      isBeta: false
    });
  }
};
exports.registerEnterpriseSearchIntegrations = registerEnterpriseSearchIntegrations;