"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../../../shared/data_panel/data_panel");
var _inference_history_logic = require("./inference_history_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/inference_history.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceHistory = () => {
  const {
    indexName,
    isLoading,
    inferenceHistory
  } = (0, _kea.useValues)(_inference_history_logic.InferenceHistoryLogic);
  const {
    fetchIndexInferenceHistory
  } = (0, _kea.useActions)(_inference_history_logic.InferenceHistoryLogic);
  (0, _react.useEffect)(() => {
    fetchIndexInferenceHistory({
      indexName
    });
  }, [indexName]);
  const historyTitle = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.title', {
    defaultMessage: 'Historical inference processors'
  });
  const historyColumns = [{
    dataType: 'string',
    field: 'pipeline',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.tableColumn.pipeline', {
      defaultMessage: 'Inference pipeline'
    })
  }, {
    dataType: 'number',
    field: 'doc_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.tableColumn.docCount', {
      defaultMessage: 'Approx. document count'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    iconType: "compute",
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 16
      }
    }, historyTitle),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.subtitle', {
      defaultMessage: 'The following inference processors were found in the _ingest.processors field of documents on this index.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: historyColumns,
    items: inferenceHistory !== null && inferenceHistory !== void 0 ? inferenceHistory : [],
    rowHeader: "pipeline",
    tableCaption: historyTitle,
    noItemsMessage: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.inferenceHistory.emptyMessage', {
      defaultMessage: 'This index has no inference history'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  })));
};
exports.InferenceHistory = InferenceHistory;