"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorAgentlessPolicy = exports.GetConnectorAgentlessPolicyApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorAgentlessPolicy = async ({
  connectorId
}) => {
  const route = `/internal/enterprise_search/${connectorId}/agentless_policy`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.getConnectorAgentlessPolicy = getConnectorAgentlessPolicy;
const GetConnectorAgentlessPolicyApiLogic = exports.GetConnectorAgentlessPolicyApiLogic = (0, _create_api_logic.createApiLogic)(['get_connector_agentless_policy'], getConnectorAgentlessPolicy);