"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactField = require("@kbn/react-field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/field_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Remappings from type to a supported `FieldIcon` type
const typeToFieldIconType = {
  integer: 'number'
};

// Mappings for types missing from `FieldIcon`
const typeToEuiIconMap = {
  object: {
    color: 'euiColorVis3',
    iconType: 'tokenObject'
  }
};
const FieldIcon = props => {
  const type = typeToFieldIconType[props.type] || props.type;
  const overrides = typeToEuiIconMap[type] || {};
  return /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, (0, _extends2.default)({
    type: type
  }, overrides, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 10
    }
  }));
};
exports.FieldIcon = FieldIcon;