"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionToolbar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _routes = require("../../../routes");
var _delete_analytics_collection_logic = require("../delete_analytics_collection_logic");
var _fetch_analytics_collection_logic = require("../fetch_analytics_collection_logic");
var _use_discover_link = require("../use_discover_link");
var _analytics_collection_toolbar_logic = require("./analytics_collection_toolbar_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_toolbar/analytics_collection_toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultQuickRanges = [{
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last7Days', {
    defaultMessage: 'Last 7 days'
  }),
  start: 'now-7d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last2Weeks', {
    defaultMessage: 'Last 2 weeks'
  }),
  start: 'now-14d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last30Days', {
    defaultMessage: 'Last 30 days'
  }),
  start: 'now-30d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last90Days', {
    defaultMessage: 'Last 90 days'
  }),
  start: 'now-90d'
}, {
  end: 'now',
  label: _i18n.i18n.translate('xpack.enterpriseSearch.analytics..units.quickRange.last1Year', {
    defaultMessage: 'Last 1 year'
  }),
  start: 'now-1y'
}];
const AnalyticsCollectionToolbar = () => {
  const discoverLink = (0, _use_discover_link.useDiscoverLink)();
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const {
    application,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    analyticsCollection
  } = (0, _kea.useValues)(_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic);
  const {
    setTimeRange,
    setRefreshInterval,
    onTimeRefresh
  } = (0, _kea.useActions)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  const {
    refreshInterval,
    timeRange
  } = (0, _kea.useValues)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  const {
    deleteAnalyticsCollection
  } = (0, _kea.useActions)(_delete_analytics_collection_logic.DeleteAnalyticsCollectionLogic);
  const {
    isLoading
  } = (0, _kea.useValues)(_delete_analytics_collection_logic.DeleteAnalyticsCollectionLogic);
  const manageDatastreamUrl = application.getUrlForApp('management', {
    path: '/data/index_management/data_streams/' + analyticsCollection.events_datastream
  });
  const handleTimeChange = ({
    start: from,
    end: to
  }) => {
    setTimeRange({
      from,
      to
    });
  };
  const closePopover = () => {
    setPopover(false);
  };
  const togglePopover = () => {
    setPopover(!isPopoverOpen);
  };
  const onRefreshChange = ({
    isPaused: pause,
    refreshInterval: value
  }) => {
    setRefreshInterval({
      pause,
      value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: timeRange.from,
    end: timeRange.to,
    refreshInterval: refreshInterval.value,
    isPaused: refreshInterval.pause,
    onTimeChange: handleTimeChange,
    onRefresh: onTimeRefresh,
    onRefreshChange: onRefreshChange,
    showUpdateButton: "iconOnly",
    updateButtonProps: {
      fill: false
    },
    width: "full",
    commonlyUsedRanges: defaultQuickRanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.analytics.collectionsView.manageButton",
      defaultMessage: "Manage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 17
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "link",
    size: "s",
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-integrate-tracker-link',
    onClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_INTEGRATE_PATH, {
      name: analyticsCollection.name
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.integrateTracker",
    defaultMessage: "Integrate JS tracker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "database",
    size: "s",
    href: manageDatastreamUrl,
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-manage-datastream-link',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.manageEventsDatastream",
    defaultMessage: "Manage events datastream",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  })), discoverLink && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "visArea",
    href: discoverLink,
    size: "s",
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-manage-discover-link',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.openInDiscover",
    defaultMessage: "Create dashboards in Discover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    color: "danger",
    fullWidth: true,
    isLoading: !isLoading,
    disabled: !isLoading,
    "data-telemetry-id": 'entSearch-analytics-overview-toolbar-delete-collection-button',
    size: "s",
    onClick: () => {
      deleteAnalyticsCollection(analyticsCollection.name);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collections.collectionsView.delete.buttonTitle",
    defaultMessage: "Delete collection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 19
    }
  }))))))));
};
exports.AnalyticsCollectionToolbar = AnalyticsCollectionToolbar;