"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUnsupportedEncryptedTypeError = void 0;
Object.defineProperty(exports, "normalizeNamespace", {
  enumerable: true,
  get: function () {
    return _get_descriptor_namespace.normalizeNamespace;
  }
});
exports.setupSavedObjects = setupSavedObjects;
var _pMap = _interopRequireDefault(require("p-map"));
var _server = require("@kbn/core/server");
var _utils = require("@kbn/core-saved-objects-api-server-internal/src/lib/apis/utils");
var _get_descriptor_namespace = require("./get_descriptor_namespace");
var _saved_objects_encryption_extension = require("./saved_objects_encryption_extension");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is based off of the SavedObjectsErrorHelpers.createUnsupportedTypeError function
// But uses a custom 'reason' aka message
const createUnsupportedEncryptedTypeError = type => _server.SavedObjectsErrorHelpers.decorateBadRequestError(new Error('Bad Request'), `Type '${type}' is not registered as an encrypted type`);
exports.createUnsupportedEncryptedTypeError = createUnsupportedEncryptedTypeError;
function setupSavedObjects({
  service,
  savedObjects,
  getStartServices,
  logger
}) {
  // Register custom saved object extension that will encrypt, decrypt and strip saved object
  // attributes where appropriate for any saved object repository request.
  savedObjects.setEncryptionExtension(({
    typeRegistry: baseTypeRegistry,
    request
  }) => {
    return new _saved_objects_encryption_extension.SavedObjectsEncryptionExtension({
      baseTypeRegistry,
      service,
      getCurrentUser: async () => {
        var _security$authc$getCu;
        const [{
          security
        }] = await getStartServices();
        return (_security$authc$getCu = security.authc.getCurrentUser(request)) !== null && _security$authc$getCu !== void 0 ? _security$authc$getCu : undefined;
      }
    });
  });
  return clientOpts => {
    const internalRepositoryAndTypeRegistryPromise = getStartServices().then(([core]) => [core.savedObjects.createInternalRepository(clientOpts === null || clientOpts === void 0 ? void 0 : clientOpts.includedHiddenTypes), core.savedObjects.getTypeRegistry()]);
    return {
      getDecryptedAsInternalUser: async (type, id, options) => {
        const [internalRepository, typeRegistry] = await internalRepositoryAndTypeRegistryPromise;
        const savedObject = await internalRepository.get(type, id, options);
        if (!service.isRegistered(savedObject.type)) {
          logger.error(`getDecryptedAsInternalUser called with non-encrypted type: ${savedObject.type}`);
          throw createUnsupportedEncryptedTypeError(savedObject.type);
        }
        return {
          ...savedObject,
          attributes: await service.decryptAttributes({
            type,
            id,
            namespace: (0, _get_descriptor_namespace.getDescriptorNamespace)(typeRegistry, type, savedObject.namespaces)
          }, savedObject.attributes)
        };
      },
      createPointInTimeFinderDecryptedAsInternalUser: async (findOptions, dependencies) => {
        const unsupportedTypes = (Array.isArray(findOptions.type) ? findOptions.type : [findOptions.type]).filter(t => !service.isRegistered(t));
        if (unsupportedTypes.length) {
          logger.error(`createPointInTimeFinderDecryptedAsInternalUser called with non-encrypted types: ${unsupportedTypes.join(', ')}`);
        }
        const [internalRepository, typeRegistry] = await internalRepositoryAndTypeRegistryPromise;
        const finder = internalRepository.createPointInTimeFinder(findOptions, dependencies);
        const finderAsyncGenerator = finder.find();
        async function* encryptedFinder() {
          for await (const res of finderAsyncGenerator) {
            const encryptedSavedObjects = await (0, _pMap.default)(res.saved_objects, async savedObject => {
              if (!service.isRegistered(savedObject.type)) {
                return {
                  ...savedObject,
                  error: (0, _utils.errorContent)(createUnsupportedEncryptedTypeError(savedObject.type))
                };
              }
              const descriptor = {
                type: savedObject.type,
                id: savedObject.id,
                namespace: (0, _get_descriptor_namespace.getDescriptorNamespace)(typeRegistry, savedObject.type, savedObject.namespaces)
              };
              try {
                return {
                  ...savedObject,
                  attributes: await service.decryptAttributes(descriptor, savedObject.attributes)
                };
              } catch (error) {
                // catch error and enrich SO with it, return stripped attributes. Then consumer of API can decide either proceed
                // with only unsecured properties or stop when error happens
                const {
                  attributes: strippedAttrs
                } = await service.stripOrDecryptAttributes(descriptor, savedObject.attributes);
                return {
                  ...savedObject,
                  attributes: strippedAttrs,
                  error
                };
              }
            }, {
              concurrency: 50
            });
            yield {
              ...res,
              saved_objects: encryptedSavedObjects
            };
          }
        }
        return {
          find: () => encryptedFinder(),
          close: finder.close.bind(finder)
        };
      }
    };
  };
}