"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInternalRuleTypesWithCache = void 0;
var _use_get_internal_rule_types_query = require("@kbn/response-ops-rules-apis/hooks/use_get_internal_rule_types_query");
var _get_internal_rule_types = require("@kbn/response-ops-rules-apis/apis/get_internal_rule_types");
var _query_client = require("../query_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInternalRuleTypesWithCache = async http => {
  // We cannot use the `useGetInternalRuleTypesQuery` hook since this fetch happens outside
  // of React, but we can interact with the query cache to avoid duplicated requests.
  // This effectively acts as a prefetch for the subsequent rule type requests performed by the
  // embeddable panel renderers
  return _query_client.queryClient.fetchQuery({
    queryKey: (0, _use_get_internal_rule_types_query.getKey)(),
    queryFn: () => (0, _get_internal_rule_types.getInternalRuleTypes)({
      http
    })
  });
};
exports.getInternalRuleTypesWithCache = getInternalRuleTypesWithCache;