"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveryGenerationsInternalRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _zodHelpers = require("@kbn/zod-helpers");
var _helpers = require("../../../helpers");
var _build_response = require("../../../../lib/build_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** depreciated internal API route, to be removed in a future release */
const getAttackDiscoveryGenerationsInternalRoute = router => {
  router.versioned.get({
    access: 'internal',
    path: _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS_INTERNAL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_elasticAssistantCommon.GetAttackDiscoveryGenerationsInternalRequestQuery)
      },
      response: {
        200: {
          body: {
            custom: (0, _zodHelpers.buildRouteValidationWithZod)(_elasticAssistantCommon.GetAttackDiscoveryGenerationsInternalResponse)
          }
        }
      }
    }
  }, async (context, request, response) => {
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    const resp = (0, _build_response.buildResponse)(response);
    const assistantContext = await context.elasticAssistant;
    const logger = assistantContext.logger;

    // Perform license and authenticated user checks:
    const checkResponse = await (0, _helpers.performChecks)({
      context: ctx,
      request,
      response
    });
    if (!checkResponse.isSuccess) {
      return checkResponse.response;
    }
    try {
      const eventLogIndex = (await context.elasticAssistant).eventLogIndex;
      const spaceId = (await context.elasticAssistant).getSpaceId();
      const {
        query
      } = request;
      const dataClient = await assistantContext.getAttackDiscoveryDataClient();
      if (!dataClient) {
        return resp.error({
          body: `Attack discovery data client not initialized`,
          statusCode: 500
        });
      }
      const currentUser = await checkResponse.currentUser;
      const result = await dataClient.getAttackDiscoveryGenerations({
        authenticatedUser: currentUser,
        eventLogIndex,
        getAttackDiscoveryGenerationsParams: {
          end: query.end,
          size: query.size,
          start: query.start
        },
        logger,
        spaceId
      });
      return response.ok({
        body: {
          ...result
        }
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getAttackDiscoveryGenerationsInternalRoute = getAttackDiscoveryGenerationsInternalRoute;