"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFieldNamesToSourceScheme = exports.transformESToConversations = exports.transformESToConversation = exports.transformESSearchToConversations = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformESToConversation = conversationSchema => {
  var _conversationSchema$r, _conversationSchema$u, _conversationSchema$u2, _conversationSchema$m;
  const replacements = (_conversationSchema$r = conversationSchema.replacements) === null || _conversationSchema$r === void 0 ? void 0 : _conversationSchema$r.reduce((acc, r) => {
    acc[r.uuid] = r.value;
    return acc;
  }, {});
  const conversation = {
    timestamp: conversationSchema['@timestamp'],
    createdAt: conversationSchema.created_at,
    createdBy: conversationSchema.created_by,
    users: (_conversationSchema$u = (_conversationSchema$u2 = conversationSchema.users) === null || _conversationSchema$u2 === void 0 ? void 0 : _conversationSchema$u2.map(user => ({
      id: user.id,
      name: user.name
    }))) !== null && _conversationSchema$u !== void 0 ? _conversationSchema$u : [],
    title: conversationSchema.title,
    category: conversationSchema.category,
    ...(conversationSchema.api_config ? {
      apiConfig: {
        actionTypeId: conversationSchema.api_config.action_type_id,
        connectorId: conversationSchema.api_config.connector_id,
        defaultSystemPromptId: conversationSchema.api_config.default_system_prompt_id,
        model: conversationSchema.api_config.model,
        provider: conversationSchema.api_config.provider
      }
    } : {}),
    excludeFromLastConversationStorage: conversationSchema.exclude_from_last_conversation_storage,
    messages: // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (_conversationSchema$m = conversationSchema.messages) === null || _conversationSchema$m === void 0 ? void 0 : _conversationSchema$m.map(message => {
      var _message$trace_data, _message$trace_data2;
      return {
        timestamp: message['@timestamp'],
        ...(message.id ? {
          id: message.id
        } : {}),
        // always return anonymized data from the client
        content: (0, _elasticAssistantCommon.replaceOriginalValuesWithUuidValues)({
          messageContent: message.content,
          replacements
        }),
        ...(message.refusal ? {
          refusal: message.refusal
        } : {}),
        ...(message.is_error ? {
          isError: message.is_error
        } : {}),
        ...(message.reader ? {
          reader: message.reader
        } : {}),
        ...(message.user ? {
          user: message.user
        } : {}),
        role: message.role,
        ...(message.metadata ? {
          metadata: {
            ...(message.metadata.content_references ? {
              contentReferences: message.metadata.content_references
            } : {})
          }
        } : {}),
        ...(message.trace_data ? {
          traceData: {
            traceId: (_message$trace_data = message.trace_data) === null || _message$trace_data === void 0 ? void 0 : _message$trace_data.trace_id,
            transactionId: (_message$trace_data2 = message.trace_data) === null || _message$trace_data2 === void 0 ? void 0 : _message$trace_data2.transaction_id
          }
        } : {})
      };
    }),
    updatedAt: conversationSchema.updated_at,
    replacements,
    namespace: conversationSchema.namespace,
    id: conversationSchema.id
  };
  return conversation;
};
exports.transformESToConversation = transformESToConversation;
const transformESSearchToConversations = response => {
  return response.hits.hits.filter(hit => hit._source !== undefined).map(hit => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const conversationSchema = hit._source;
    return transformESToConversation({
      ...conversationSchema,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: hit._id
    });
  });
};
exports.transformESSearchToConversations = transformESSearchToConversations;
const transformESToConversations = response => {
  return response.map(conversationSchema => transformESToConversation(conversationSchema));
};
exports.transformESToConversations = transformESToConversations;
const transformFieldNamesToSourceScheme = fields => {
  return fields.map(f => {
    switch (f) {
      case 'timestamp':
        return '@timestamp';
      case 'apiConfig':
        return 'api_config';
      case 'createdBy':
        return 'created_by';
      case 'apiConfig.actionTypeId':
        return 'api_config.action_type_id';
      case 'apiConfig.connectorId':
        return 'api_config.connector_id';
      case 'apiConfig.defaultSystemPromptId':
        return 'api_config.default_system_prompt_id';
      case 'apiConfig.model':
        return 'api_config.model';
      case 'apiConfig.provider':
        return 'api_config.provider';
      default:
        return _lodash.default.snakeCase(f);
    }
  });
};
exports.transformFieldNamesToSourceScheme = transformFieldNamesToSourceScheme;