"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationAuditAction = exports.AUDIT_TYPE = exports.AUDIT_OUTCOME = exports.AUDIT_CATEGORY = void 0;
exports.conversationAuditEvent = conversationAuditEvent;
exports.getAuditAction = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AUDIT_TYPE = exports.AUDIT_TYPE = /*#__PURE__*/function (AUDIT_TYPE) {
  AUDIT_TYPE["CHANGE"] = "change";
  AUDIT_TYPE["ACCESS"] = "access";
  AUDIT_TYPE["CREATION"] = "creation";
  return AUDIT_TYPE;
}({});
let AUDIT_CATEGORY = exports.AUDIT_CATEGORY = /*#__PURE__*/function (AUDIT_CATEGORY) {
  AUDIT_CATEGORY["AUTHENTICATION"] = "authentication";
  AUDIT_CATEGORY["DATABASE"] = "database";
  AUDIT_CATEGORY["WEB"] = "web";
  return AUDIT_CATEGORY;
}({});
let AUDIT_OUTCOME = exports.AUDIT_OUTCOME = /*#__PURE__*/function (AUDIT_OUTCOME) {
  AUDIT_OUTCOME["FAILURE"] = "failure";
  AUDIT_OUTCOME["SUCCESS"] = "success";
  AUDIT_OUTCOME["UNKNOWN"] = "unknown";
  return AUDIT_OUTCOME;
}({});
let ConversationAuditAction = exports.ConversationAuditAction = /*#__PURE__*/function (ConversationAuditAction) {
  ConversationAuditAction["SHARED"] = "security_assistant_conversation_shared";
  ConversationAuditAction["PRIVATE"] = "security_assistant_conversation_private";
  ConversationAuditAction["RESTRICTED"] = "security_assistant_conversation_restricted";
  return ConversationAuditAction;
}({});
const getAuditAction = conversationSharedState => {
  if (conversationSharedState === _elasticAssistantCommon.ConversationSharedState.PRIVATE) {
    return ConversationAuditAction.PRIVATE;
  }
  if (conversationSharedState === _elasticAssistantCommon.ConversationSharedState.RESTRICTED) {
    return ConversationAuditAction.RESTRICTED;
  }
  return ConversationAuditAction.SHARED;
};
exports.getAuditAction = getAuditAction;
const conversationEventVerbs = {
  [ConversationAuditAction.SHARED]: ['share', 'sharing', 'shared'],
  [ConversationAuditAction.RESTRICTED]: ['restrict', 'restricting', 'restricted'],
  [ConversationAuditAction.PRIVATE]: ['make private', 'making private', 'made private']
};
const conversationEventTypes = {
  [ConversationAuditAction.SHARED]: AUDIT_TYPE.CHANGE,
  [ConversationAuditAction.PRIVATE]: AUDIT_TYPE.CHANGE,
  [ConversationAuditAction.RESTRICTED]: AUDIT_TYPE.CHANGE
};
function conversationAuditEvent({
  action,
  error,
  id,
  title,
  outcome,
  users
}) {
  let doc = 'a conversation';
  if (id && title) {
    doc = `conversation [id=${id}, title="${title}"]`;
  } else if (id) {
    doc = `conversation [id=${id}]`;
  } else if (title) {
    doc = `conversation [title="${title}"]`;
  }
  const [present, progressive, past] = conversationEventVerbs[action];
  let message = error ? `Failed attempt to ${present} ${doc}` : outcome === 'unknown' ? `User is ${progressive} ${doc}` : `User has ${past} ${doc}`;
  if ((action === ConversationAuditAction.SHARED || action === ConversationAuditAction.RESTRICTED) && users) {
    const usersMessage = users.length > 0 ? ` to user${users.length > 1 ? 's' : ''} (${users.map(u => formatUserAsString(u)).join(', ')})` : ' to all users in the space';
    message = `${message}${usersMessage}`;
  }
  const type = conversationEventTypes[action];
  return {
    message,
    event: {
      action,
      category: [AUDIT_CATEGORY.DATABASE],
      type: type ? [type] : undefined,
      outcome: error ? AUDIT_OUTCOME.FAILURE : outcome !== null && outcome !== void 0 ? outcome : AUDIT_OUTCOME.SUCCESS
    },
    error: error && {
      code: error.name,
      message: error.message
    }
  };
}
const formatUserAsString = user => {
  if (user.name && user.id) {
    return `[id=${user.id}, name=${user.name}]`;
  }
  if (user.name) {
    return `[name=${user.name}]`;
  }
  if (user.id) {
    return `[id=${user.id}]`;
  }
  return '';
};