"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComments = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _user_avatar = require("./user_avatar");
var _stream = require("./stream");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Matches EuiAvatar L
const SpinnerWrapper = _styled.default.div`
  width: 40px;
  height: 40px;
  display: flex;
  justify-content: center;
`;
const transformMessageWithReplacements = ({
  message,
  content,
  showAnonymizedValues,
  replacements
}) => {
  return {
    ...message,
    content: showAnonymizedValues ? content : (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: content,
      replacements
    })
  };
};
const getComments = args => ({
  abortStream,
  contentReferencesVisible,
  currentConversation,
  isConversationOwner,
  isFetchingResponse,
  refetchCurrentConversation,
  regenerateMessage,
  setIsStreaming,
  showAnonymizedValues,
  systemPromptContent
}) => {
  if (!currentConversation) return [];
  const regenerateMessageOfConversation = () => {
    regenerateMessage(currentConversation.id);
  };
  const extraLoadingComment = isFetchingResponse ? [{
    username: i18n.ASSISTANT,
    timelineAvatar: /*#__PURE__*/_react.default.createElement(SpinnerWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    })),
    timestamp: '...',
    children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
      abortStream: abortStream,
      content: "",
      refetchCurrentConversation: refetchCurrentConversation,
      regenerateMessage: regenerateMessageOfConversation,
      setIsStreaming: setIsStreaming,
      contentReferencesVisible: contentReferencesVisible,
      transformMessage: () => ({
        content: ''
      }),
      contentReferences: null,
      messageRole: "assistant",
      isFetching: true
      // we never need to append to a code block in the loading comment, which is what this index is used for
      ,
      index: 999,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    })
  }] : [];
  return [...(systemPromptContent && currentConversation.messages.length ? [{
    username: i18n.SYSTEM,
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantAvatar, {
      name: "machine",
      size: "l",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 31
      }
    }),
    timestamp: currentConversation.messages[0].timestamp.length === 0 ? new Date().toLocaleString() : new Date(currentConversation.messages[0].timestamp).toLocaleString(),
    children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
      abortStream: abortStream,
      content: systemPromptContent,
      refetchCurrentConversation: refetchCurrentConversation,
      regenerateMessage: regenerateMessageOfConversation,
      setIsStreaming: setIsStreaming,
      contentReferences: null,
      contentReferencesVisible: contentReferencesVisible,
      transformMessage: () => ({
        content: ''
      }),
      messageRole: 'assistant'
      // we never need to append to a code block in the system comment, which is what this index is used for
      ,
      index: 999,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 17
      }
    })
  }] : []), ...currentConversation.messages.map((message, index) => {
    var _message$user, _message$content, _message$metadata;
    const isLastComment = index === currentConversation.messages.length - 1;
    const isUser = message.role === 'user';
    const replacements = currentConversation.replacements;
    const user = isUser ? (_message$user = message.user) !== null && _message$user !== void 0 ? _message$user : (0, _elasticAssistantCommon.getCurrentConversationOwner)(currentConversation) : undefined;
    const messageProps = {
      timelineAvatar: isUser ? /*#__PURE__*/_react.default.createElement(_user_avatar.SecurityUserAvatar, {
        user: user,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantAvatar, {
        name: "machine",
        size: "l",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 13
        }
      }),
      timestamp: i18n.AT(message.timestamp.length === 0 ? new Date().toLocaleString() : new Date(message.timestamp).toLocaleString()),
      username: isUser ? /*#__PURE__*/_react.default.createElement(_user_avatar.SecurityUserName, {
        user: user,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 30
        }
      }) : i18n.ASSISTANT,
      eventColor: message.isError ? 'danger' : undefined
    };
    const isControlsEnabled = isLastComment && !isUser && isConversationOwner;
    const transformMessage = content => transformMessageWithReplacements({
      message,
      content,
      showAnonymizedValues,
      replacements
    });

    // message still needs to stream, no actions returned and replacements handled by streamer
    if (!(message.content && message.content.length)) {
      return {
        ...messageProps,
        children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
          abortStream: abortStream,
          contentReferences: null,
          contentReferencesVisible: contentReferencesVisible,
          index: index,
          isControlsEnabled: isControlsEnabled,
          isError: message.isError,
          reader: message.reader,
          refetchCurrentConversation: refetchCurrentConversation,
          regenerateMessage: regenerateMessageOfConversation,
          setIsStreaming: setIsStreaming,
          transformMessage: transformMessage,
          messageRole: message.role,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 176,
            columnNumber: 15
          }
        })
      };
    }

    // transform message here so we can send correct message to CommentActions
    const transformedMessage = transformMessage((_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '');
    return {
      ...messageProps,
      actions: /*#__PURE__*/_react.default.createElement(args.CommentActions, {
        message: transformedMessage,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 20
        }
      }),
      children: /*#__PURE__*/_react.default.createElement(_stream.StreamComment, {
        abortStream: abortStream,
        content: transformedMessage.content,
        contentReferences: (_message$metadata = message.metadata) === null || _message$metadata === void 0 ? void 0 : _message$metadata.contentReferences,
        contentReferencesVisible: contentReferencesVisible,
        index: index,
        isControlsEnabled: isControlsEnabled,
        isError: message.isError
        // reader is used to determine if streaming controls are shown
        ,
        reader: transformedMessage.reader,
        regenerateMessage: regenerateMessageOfConversation,
        refetchCurrentConversation: refetchCurrentConversation,
        setIsStreaming: setIsStreaming,
        transformMessage: transformMessage,
        messageRole: message.role,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 13
        }
      })
    };
  }), ...extraLoadingComment];
};
exports.getComments = getComments;