"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformAnonymizationFieldsBulkActionResponse = exports.PerformAnonymizationFieldsBulkActionRequestBody = exports.NormalizedAnonymizationFieldError = exports.AnonymizationFieldsBulkCrudActionResults = exports.AnonymizationFieldsBulkCrudActionResponse = exports.AnonymizationFieldsBulkActionSkipResult = exports.AnonymizationFieldsBulkActionSkipReason = exports.AnonymizationFieldUpdateProps = exports.AnonymizationFieldResponse = exports.AnonymizationFieldDetailsInError = exports.AnonymizationFieldCreateProps = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Anonymization Fields Actions API endpoint
 *   version: 2023-10-31
 */

/**
 * Reason why the anonymization field was not modified.
 */

const AnonymizationFieldsBulkActionSkipReason = exports.AnonymizationFieldsBulkActionSkipReason = _zod.z.literal('ANONYMIZATION_FIELD_NOT_MODIFIED');
const AnonymizationFieldsBulkActionSkipResult = exports.AnonymizationFieldsBulkActionSkipResult = _zod.z.object({
  /**
   * The ID of the anonymization field that was not modified.
   */
  id: _zod.z.string(),
  /**
   * Name of the anonymization field that was not modified.
   */
  name: _zod.z.string().optional(),
  /**
   * Reason why the anonymization field was not modified.
   */
  skip_reason: AnonymizationFieldsBulkActionSkipReason
});
const AnonymizationFieldDetailsInError = exports.AnonymizationFieldDetailsInError = _zod.z.object({
  /**
   * The ID of the anonymization field.
   */
  id: _zod.z.string(),
  /**
   * Name of the anonymization field.
   */
  name: _zod.z.string().optional()
});
const NormalizedAnonymizationFieldError = exports.NormalizedAnonymizationFieldError = _zod.z.object({
  /**
   * Error message.
   */
  message: _zod.z.string(),
  /**
   * Status code of the response.
   */
  status_code: _zod.z.number().int(),
  /**
   * Error code indicating the type of failure.
   */
  err_code: _zod.z.string().optional(),
  /**
   * Array of anonymization fields that caused the error.
   */
  anonymization_fields: _zod.z.array(AnonymizationFieldDetailsInError)
});
const AnonymizationFieldResponse = exports.AnonymizationFieldResponse = _zod.z.object({
  /**
   * The ID of the anonymization field.
   */
  id: _common_attributes.NonEmptyString,
  /**
   * Timestamp when the anonymization field was initially created.
   */
  timestamp: _common_attributes.NonEmptyTimestamp.optional(),
  /**
   * Name of the anonymization field.
   */
  field: _zod.z.string(),
  /**
   * Whether this field is allowed to be sent to the model.
   */
  allowed: _zod.z.boolean().optional(),
  /**
   * Whether this field should be anonymized.
   */
  anonymized: _zod.z.boolean().optional(),
  /**
   * Timestamp of the last update.
   */
  updatedAt: _zod.z.string().optional(),
  /**
   * Username of the person who last updated the field.
   */
  updatedBy: _zod.z.string().optional(),
  /**
   * Timestamp of when the anonymization field was created.
   */
  createdAt: _zod.z.string().optional(),
  /**
   * Username of the person who created the anonymization field.
   */
  createdBy: _zod.z.string().optional(),
  /**
   * Kibana space in which this anonymization field exists.
   */
  namespace: _zod.z.string().optional()
});
const AnonymizationFieldsBulkCrudActionResults = exports.AnonymizationFieldsBulkCrudActionResults = _zod.z.object({
  /**
   * List of anonymization fields successfully updated.
   */
  updated: _zod.z.array(AnonymizationFieldResponse),
  /**
   * List of anonymization fields successfully created.
   */
  created: _zod.z.array(AnonymizationFieldResponse),
  deleted: _zod.z.array(_zod.z.string()),
  /**
   * List of anonymization fields that were skipped during the operation.
   */
  skipped: _zod.z.array(AnonymizationFieldsBulkActionSkipResult)
});
const AnonymizationFieldsBulkCrudActionResponse = exports.AnonymizationFieldsBulkCrudActionResponse = _zod.z.object({
  /**
   * Indicates if the bulk action was successful.
   */
  success: _zod.z.boolean().optional(),
  /**
   * HTTP status code returned.
   */
  status_code: _zod.z.number().int().optional(),
  /**
   * Message providing information about the bulk action result.
   */
  message: _zod.z.string().optional(),
  /**
   * Total number of anonymization fields processed.
   */
  anonymization_fields_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: AnonymizationFieldsBulkCrudActionResults,
    summary: _common_attributes.BulkCrudActionSummary,
    /**
     * List of errors that occurred during the bulk operation.
     */
    errors: _zod.z.array(NormalizedAnonymizationFieldError).optional()
  })
});
const AnonymizationFieldCreateProps = exports.AnonymizationFieldCreateProps = _zod.z.object({
  /**
   * Name of the anonymization field to create.
   */
  field: _zod.z.string(),
  /**
   * Whether this field is allowed to be sent to the model.
   */
  allowed: _zod.z.boolean().optional(),
  /**
   * Whether this field should be anonymized.
   */
  anonymized: _zod.z.boolean().optional()
});
const AnonymizationFieldUpdateProps = exports.AnonymizationFieldUpdateProps = _zod.z.object({
  /**
   * The ID of the anonymization field to update.
   */
  id: _zod.z.string(),
  /**
   * Whether this field is allowed to be sent to the model.
   */
  allowed: _zod.z.boolean().optional(),
  /**
   * Whether this field should be anonymized.
   */
  anonymized: _zod.z.boolean().optional()
});
const PerformAnonymizationFieldsBulkActionRequestBody = exports.PerformAnonymizationFieldsBulkActionRequestBody = _zod.z.object({
  /**
   * Object containing the query to filter anonymization fields and/or an array of anonymization field IDs to delete.
   */
  delete: _common_attributes.BulkActionBase.optional(),
  /**
   * Array of anonymization fields to create.
   */
  create: _zod.z.array(AnonymizationFieldCreateProps).optional(),
  /**
   * Array of anonymization fields to update.
   */
  update: _zod.z.array(AnonymizationFieldUpdateProps).optional()
});
const PerformAnonymizationFieldsBulkActionResponse = exports.PerformAnonymizationFieldsBulkActionResponse = AnonymizationFieldsBulkCrudActionResponse;