"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultSort = getDefaultSort;
var _get_sort = require("./get_sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * use in case the user didn't manually sort.
 * the default sort is returned depending on the data view or non for ES|QL queries
 */
function getDefaultSort(dataView, defaultSortOrder = 'desc', hidingTimeColumn = false, isEsqlMode) {
  if (isEsqlMode) {
    return [];
  }
  if (dataView !== null && dataView !== void 0 && dataView.timeFieldName && (
  // If the data view doesn't have a getFieldByName method (e.g. if it's a spec or list item),
  // we assume the time field is sortable since we can't know for sure
  !('getFieldByName' in dataView) || (0, _get_sort.isSortable)(dataView.timeFieldName, dataView, isEsqlMode)) && !hidingTimeColumn) {
    return [[dataView.timeFieldName, defaultSortOrder]];
  } else {
    return [];
  }
}