"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRefreshIntervalValid = isRefreshIntervalValid;
exports.isTimeRangeValid = isTimeRangeValid;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isTimeRangeValid(timeRange) {
  if (!(timeRange !== null && timeRange !== void 0 && timeRange.from) || !(timeRange !== null && timeRange !== void 0 && timeRange.to)) {
    return false;
  }
  const fromMoment = _datemath.default.parse(timeRange.from);
  const toMoment = _datemath.default.parse(timeRange.to);
  return Boolean(fromMoment && toMoment && fromMoment.isValid() && toMoment.isValid());
}
function isRefreshIntervalValid(refreshInterval) {
  if (!refreshInterval) {
    return false;
  }
  return typeof (refreshInterval === null || refreshInterval === void 0 ? void 0 : refreshInterval.value) === 'number' && (refreshInterval === null || refreshInterval === void 0 ? void 0 : refreshInterval.value) >= 0 && typeof (refreshInterval === null || refreshInterval === void 0 ? void 0 : refreshInterval.pause) === 'boolean';
}