"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedSearchAliasMatchRedirect = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-search-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useSavedSearchAliasMatchRedirect = ({
  discoverSession,
  spaces,
  history
}) => {
  (0, _react.useEffect)(() => {
    async function aliasMatchRedirect() {
      if (discoverSession) {
        var _discoverSession$shar;
        const sharingSavedObjectProps = (_discoverSession$shar = discoverSession.sharingSavedObjectProps) !== null && _discoverSession$shar !== void 0 ? _discoverSession$shar : {};
        const {
          outcome,
          aliasPurpose,
          aliasTargetId
        } = sharingSavedObjectProps;
        if (spaces && aliasTargetId && outcome === 'aliasMatch') {
          await spaces.ui.redirectLegacyUrl({
            path: `${(0, _public.getSavedSearchUrl)(aliasTargetId)}${history.location.search}`,
            aliasPurpose,
            objectNoun: _i18n.i18n.translate('discover.savedSearchAliasMatchRedirect.objectNoun', {
              defaultMessage: `''{savedSearch}'' Discover session`,
              values: {
                savedSearch: discoverSession.title
              }
            })
          });
        }
      }
    }
    aliasMatchRedirect();
  }, [discoverSession, spaces, history]);
};
exports.useSavedSearchAliasMatchRedirect = useSavedSearchAliasMatchRedirect;