"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegacyLogStreamEmbeddableFactory = void 0;
var _src = require("@kbn/discover-utils/src");
var _common = require("@kbn/saved-search-plugin/common");
var _get_search_embeddable_factory = require("./get_search_embeddable_factory");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getLegacyLogStreamEmbeddableFactory = (...[{
  startServices,
  discoverServices
}]) => {
  const searchEmbeddableFactory = (0, _get_search_embeddable_factory.getSearchEmbeddableFactory)({
    startServices,
    discoverServices
  });
  const logStreamEmbeddableFactory = {
    type: _constants.LEGACY_LOG_STREAM_EMBEDDABLE,
    buildEmbeddable: async ({
      initialState,
      ...restParams
    }) => {
      var _initialState$rawStat, _initialState$rawStat2;
      const searchSource = await discoverServices.data.search.searchSource.create();
      let fallbackPattern = 'logs-*-*';
      // Given that the logDataAccess service is an optional dependency with discover, we need to check if it exists
      if (discoverServices.logsDataAccess) {
        fallbackPattern = await discoverServices.logsDataAccess.services.logSourcesService.getFlattenedLogSources();
      }
      const spec = (0, _src.getAllLogsDataViewSpec)({
        allLogsIndexPattern: fallbackPattern
      });
      const dataView = await discoverServices.data.dataViews.create(spec);

      // Finally assign the data view to the search source
      searchSource.setField('index', dataView);
      const savedSearch = {
        title: initialState.rawState.title,
        description: initialState.rawState.description,
        timeRange: initialState.rawState.timeRange,
        sort: (_initialState$rawStat = initialState.rawState.sort) !== null && _initialState$rawStat !== void 0 ? _initialState$rawStat : [],
        columns: (_initialState$rawStat2 = initialState.rawState.columns) !== null && _initialState$rawStat2 !== void 0 ? _initialState$rawStat2 : [],
        searchSource,
        managed: false
      };
      const {
        searchSourceJSON,
        references
      } = searchSource.serialize();
      initialState = {
        ...initialState,
        rawState: {
          ...initialState.rawState,
          attributes: {
            ...(0, _common.toSavedSearchAttributes)(savedSearch, searchSourceJSON),
            references
          }
        }
      };
      return searchEmbeddableFactory.buildEmbeddable({
        initialState,
        ...restParams
      });
    }
  };
  return logStreamEmbeddableFactory;
};
exports.getLegacyLogStreamEmbeddableFactory = getLegacyLogStreamEmbeddableFactory;