"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsAllowedValueDescription = void 0;
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helper function to return the description of an allowed value of the specified field
 * @param fieldName
 * @param value
 * @returns ecs description of the value
 */
const getEcsAllowedValueDescription = (fieldsMetadata = {}, value) => {
  var _fieldsMetadata$event, _fieldsMetadata$event2, _allowedValues$find$d, _allowedValues$find;
  const allowedValues = (_fieldsMetadata$event = (_fieldsMetadata$event2 = fieldsMetadata['event.category']) === null || _fieldsMetadata$event2 === void 0 ? void 0 : _fieldsMetadata$event2.allowed_values) !== null && _fieldsMetadata$event !== void 0 ? _fieldsMetadata$event : [];
  const result = (_allowedValues$find$d = allowedValues === null || allowedValues === void 0 ? void 0 : (_allowedValues$find = allowedValues.find(item => item.name === value)) === null || _allowedValues$find === void 0 ? void 0 : _allowedValues$find.description) !== null && _allowedValues$find$d !== void 0 ? _allowedValues$find$d : i18n.noEcsDescriptionReason;
  return result;
};
exports.getEcsAllowedValueDescription = getEcsAllowedValueDescription;