"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetDocViewer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _rxjs = require("rxjs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/observability/log_document_profile/accessors/get_doc_viewer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createGetDocViewer = services => (prev, {
  context
}) => params => {
  const prevDocViewer = prev(params);
  const logsAIAssistantFeature = services.discoverShared.features.registry.getById('observability-logs-ai-assistant');
  const streamsFeature = services.discoverShared.features.registry.getById('streams');
  const indexes = {
    apm: {
      errors: services.apmContextService.errorsService.getErrorsIndexPattern(),
      traces: services.apmContextService.tracesService.getAllTracesIndexPattern()
    },
    logs: services.logsContextService.getAllLogsIndexPattern()
  };
  return {
    ...prevDocViewer,
    docViewsRegistry: registry => {
      registry.add({
        id: 'doc_view_logs_overview',
        title: _i18n.i18n.translate('discover.docViews.logsOverview.title', {
          defaultMessage: 'Log overview'
        }),
        order: 0,
        component: function LogOverviewTab(props) {
          var _context$logOverviewC;
          const [logsOverviewApi, setLogsOverviewApi] = (0, _react.useState)(null);
          const initialAccordionSection = (0, _react.useRef)((_context$logOverviewC = context.logOverviewContext$.getValue()) === null || _context$logOverviewC === void 0 ? void 0 : _context$logOverviewC.initialAccordionSection);
          (0, _react.useEffect)(() => {
            if (!logsOverviewApi) {
              return;
            }
            context.logOverviewContext$.next(undefined);
            if (initialAccordionSection.current) {
              logsOverviewApi.openAndScrollToSection(initialAccordionSection.current);
            }
            initialAccordionSection.current = undefined;
            const subscription = context.logOverviewContext$.pipe((0, _rxjs.skip)(1), (0, _rxjs.filter)(overviewContext => {
              return overviewContext !== undefined && overviewContext.initialAccordionSection !== undefined && overviewContext.recordId === props.hit.id;
            })).subscribe(overviewContext => {
              logsOverviewApi.openAndScrollToSection(overviewContext.initialAccordionSection);
              context.logOverviewContext$.next(undefined);
            });
            return () => {
              subscription.unsubscribe();
            };
          }, [logsOverviewApi, props.hit.id]);
          return /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerLogsOverview, (0, _extends2.default)({}, props, {
            ref: setLogsOverviewApi,
            renderAIAssistant: logsAIAssistantFeature === null || logsAIAssistantFeature === void 0 ? void 0 : logsAIAssistantFeature.render,
            renderFlyoutStreamField: streamsFeature === null || streamsFeature === void 0 ? void 0 : streamsFeature.renderFlyoutStreamField,
            renderFlyoutStreamProcessingLink: streamsFeature === null || streamsFeature === void 0 ? void 0 : streamsFeature.renderFlyoutStreamProcessingLink,
            indexes: indexes,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 91,
              columnNumber: 15
            }
          }));
        }
      });
      return prevDocViewer.docViewsRegistry(registry);
    }
  };
};
exports.createGetDocViewer = createGetDocViewer;