"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStateDefaults = getStateDefaults;
var _lodash = require("lodash");
var _unifiedHistogram = require("@kbn/unified-histogram");
var _discoverUtils = require("@kbn/discover-utils");
var _esQuery = require("@kbn/es-query");
var _get_valid_view_mode = require("../../utils/get_valid_view_mode");
var _data_sources = require("../../../../../common/data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDefaultColumns(persistedTab, uiSettings) {
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.columns && persistedTab.columns.length > 0) {
    return [...persistedTab.columns];
  }
  return [...uiSettings.get(_discoverUtils.DEFAULT_COLUMNS_SETTING)];
}
function getStateDefaults({
  persistedTab,
  dataView,
  services
}) {
  var _persistedTab$sort, _persistedTab$sort2;
  const {
    data,
    uiSettings,
    storage
  } = services;
  const query = (persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.serializedSearchSource.query) || data.query.queryString.getDefaultQuery();
  const isEsqlQuery = (0, _esQuery.isOfAggregateQueryType)(query);
  // If the data view doesn't have a getFieldByName method (e.g. if it's a spec or list item),
  // we assume the sort array is valid since we can't know for sure
  const sort = dataView && 'getFieldByName' in dataView ? (0, _discoverUtils.getSortArray)((_persistedTab$sort = persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.sort) !== null && _persistedTab$sort !== void 0 ? _persistedTab$sort : [], dataView, isEsqlQuery) : (_persistedTab$sort2 = persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.sort) !== null && _persistedTab$sort2 !== void 0 ? _persistedTab$sort2 : [];
  const columns = getDefaultColumns(persistedTab, uiSettings);
  const chartHidden = (0, _unifiedHistogram.getChartHidden)(storage, 'discover');
  const dataSource = (0, _data_sources.createDataSource)({
    dataView: dataView !== null && dataView !== void 0 ? dataView : persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.serializedSearchSource.index,
    query
  });
  const defaultState = {
    query,
    sort: !sort.length ? (0, _discoverUtils.getDefaultSort)(dataView, uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING, 'desc'), uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false), isEsqlQuery) : sort,
    columns,
    dataSource,
    interval: 'auto',
    filters: (0, _lodash.cloneDeep)(persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.serializedSearchSource.filter),
    hideChart: chartHidden,
    viewMode: undefined,
    hideAggregatedPreview: undefined,
    savedQuery: undefined,
    rowHeight: undefined,
    headerRowHeight: undefined,
    rowsPerPage: undefined,
    sampleSize: undefined,
    grid: undefined,
    breakdownField: undefined,
    density: undefined
  };
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.grid) {
    defaultState.grid = persistedTab.grid;
  }
  if ((persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.hideChart) !== undefined) {
    defaultState.hideChart = persistedTab.hideChart;
  }
  if ((persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.rowHeight) !== undefined) {
    defaultState.rowHeight = persistedTab.rowHeight;
  }
  if ((persistedTab === null || persistedTab === void 0 ? void 0 : persistedTab.headerRowHeight) !== undefined) {
    defaultState.headerRowHeight = persistedTab.headerRowHeight;
  }
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.viewMode) {
    defaultState.viewMode = (0, _get_valid_view_mode.getValidViewMode)({
      viewMode: persistedTab.viewMode,
      isEsqlMode: isEsqlQuery
    });
  }
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.hideAggregatedPreview) {
    defaultState.hideAggregatedPreview = persistedTab.hideAggregatedPreview;
  }
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.rowsPerPage) {
    defaultState.rowsPerPage = persistedTab.rowsPerPage;
  }
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.sampleSize) {
    defaultState.sampleSize = persistedTab.sampleSize;
  }
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.breakdownField) {
    defaultState.breakdownField = persistedTab.breakdownField;
  }
  if (persistedTab !== null && persistedTab !== void 0 && persistedTab.density) {
    defaultState.density = persistedTab.density;
  }
  return defaultState;
}