"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseControlGroupJson = exports.getSerializedSearchSourceDataViewDetails = exports.extractEsqlVariables = exports.createTabItem = exports.createTabActionInjector = exports.createInternalStateAsyncThunk = void 0;
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _unifiedTabs = require("@kbn/unified-tabs");
var _toolkit = require("@reduxjs/toolkit");
var _common = require("@kbn/kibana-utils-plugin/common");
var _controlsConstants = require("@kbn/controls-constants");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// For some reason if this is not explicitly typed, TypeScript fails with the following error:
// TS7056: The inferred type of this node exceeds the maximum length the compiler will serialize. An explicit type annotation is needed.

const createInternalStateAsyncThunk = (...[typePrefix, payloadCreator, options]) => {
  return (0, _toolkit.createAsyncThunk)(typePrefix, payloadCreator, {
    ...options,
    serializeError: error => {
      var _options$serializeErr, _options$serializeErr2;
      return error instanceof _common.SavedObjectNotFound ? error : (_options$serializeErr = options === null || options === void 0 ? void 0 : (_options$serializeErr2 = options.serializeError) === null || _options$serializeErr2 === void 0 ? void 0 : _options$serializeErr2.call(options, error)) !== null && _options$serializeErr !== void 0 ? _options$serializeErr : (0, _toolkit.miniSerializeError)(error);
    }
  });
};
exports.createInternalStateAsyncThunk = createInternalStateAsyncThunk;
const createTabActionInjector = tabId => actionCreator => payload => {
  return actionCreator({
    ...(payload !== null && payload !== void 0 ? payload : {}),
    tabId
  });
};
exports.createTabActionInjector = createTabActionInjector;
const DEFAULT_TAB_LABEL = _i18n.i18n.translate('discover.defaultTabLabel', {
  defaultMessage: 'Untitled'
});
const createTabItem = allTabs => {
  const id = (0, _uuid.v4)();
  const baseLabel = DEFAULT_TAB_LABEL;
  const nextNumber = (0, _unifiedTabs.getNextTabNumber)(allTabs, baseLabel);
  const label = nextNumber ? `${baseLabel} ${nextNumber}` : baseLabel;
  return {
    id,
    label
  };
};

/**
 * Gets a minimal representation of the data view in a serialized
 * search source. Useful when you want e.g. the time field name
 * and don't have access to the full data view.
 */
exports.createTabItem = createTabItem;
const getSerializedSearchSourceDataViewDetails = (serializedSearchSource, savedDataViews) => {
  const dataViewIdOrSpec = serializedSearchSource === null || serializedSearchSource === void 0 ? void 0 : serializedSearchSource.index;
  if (!dataViewIdOrSpec) {
    return undefined;
  }
  if ((0, _lodash.isObject)(dataViewIdOrSpec)) {
    return {
      id: dataViewIdOrSpec.id,
      timeFieldName: dataViewIdOrSpec.timeFieldName
    };
  }
  const dataViewListItem = savedDataViews.find(item => item.id === dataViewIdOrSpec);
  if (!dataViewListItem) {
    return undefined;
  }
  return {
    id: dataViewListItem.id,
    timeFieldName: dataViewListItem.timeFieldName
  };
};

/**
 * Parses a JSON string into a ControlPanelsState object.
 * If the JSON is invalid or null, it returns an empty object.
 *
 * @param jsonString - The JSON string to parse.
 * @returns A ControlPanelsState object or an empty object if parsing fails.
 */
exports.getSerializedSearchSourceDataViewDetails = getSerializedSearchSourceDataViewDetails;
const parseControlGroupJson = jsonString => {
  try {
    return jsonString ? JSON.parse(jsonString) : {};
  } catch (e) {
    return {};
  }
};

/**
 * @param panels - The control panels state, which may be null.
 * @description Extracts ESQL variables from the control panels state.
 * Each ESQL control panel is expected to have a `variableName`, `variableType`, and `selectedOptions`.
 * Returns an array of `ESQLControlVariable` objects.
 * If `panels` is null or empty, it returns an empty array.
 * @returns An array of ESQLControlVariable objects.
 */
exports.parseControlGroupJson = parseControlGroupJson;
const extractEsqlVariables = panels => {
  if (!panels || Object.keys(panels).length === 0) {
    return [];
  }
  const variables = Object.values(panels).reduce((acc, panel) => {
    if (panel.type === _controlsConstants.ESQL_CONTROL) {
      var _panel$selectedOption, _panel$selectedOption2, _panel$selectedOption3;
      acc.push({
        key: panel.variableName,
        type: panel.variableType,
        // If the selected option is not a number, keep it as a string
        value: isNaN(Number((_panel$selectedOption = panel.selectedOptions) === null || _panel$selectedOption === void 0 ? void 0 : _panel$selectedOption[0])) ? (_panel$selectedOption2 = panel.selectedOptions) === null || _panel$selectedOption2 === void 0 ? void 0 : _panel$selectedOption2[0] : Number((_panel$selectedOption3 = panel.selectedOptions) === null || _panel$selectedOption3 === void 0 ? void 0 : _panel$selectedOption3[0])
      });
    }
    return acc;
  }, []);
  return variables;
};
exports.extractEsqlVariables = extractEsqlVariables;