"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBackgroundSearchFlyout = void 0;
var _backgroundSearch = require("@kbn/background-search");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getBackgroundSearchFlyout = ({
  onClick
}) => {
  return {
    id: _discoverUtils.AppMenuActionId.backgroundsearch,
    type: _discoverUtils.AppMenuActionType.primary,
    controlProps: {
      label: _i18n.i18n.translate('discover.localMenu.localMenu.openBackgroundSearchFlyoutTitle', {
        defaultMessage: 'Background searches'
      }),
      // TODO: Replace when the backgroundTask icon is available in EUI
      iconType: _backgroundSearch.EuiIconBackgroundTask,
      testId: 'openBackgroundSearchFlyoutButton',
      onClick
    }
  };
};
exports.getBackgroundSearchFlyout = getBackgroundSearchFlyout;