"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InitializationError = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _react = _interopRequireWildcard(require("react"));
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _branded_loading_indicator = require("./branded_loading_indicator");
var _redux = require("../../state_management/redux");
var _error_alert = require("../../../../components/common/error_alert");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/application/main/components/single_tab_view/initialization_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InitializationError = ({
  error: originalError
}) => {
  const error = (0, _react.useMemo)(() => originalError instanceof Error ? originalError : new Error(originalError.message), [originalError]);
  if (error instanceof _public.SavedObjectNotFound) {
    return /*#__PURE__*/_react.default.createElement(RedirectWhenSavedObjectNotFound, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  });
};
exports.InitializationError = InitializationError;
const RedirectWhenSavedObjectNotFound = ({
  error
}) => {
  const {
    application: {
      navigateToApp
    },
    core,
    history,
    http: {
      basePath
    },
    toastNotifications,
    urlTracker
  } = (0, _use_discover_services.useDiscoverServices)();
  const discoverSessionId = (0, _redux.useInternalStateSelector)(state => {
    var _state$persistedDisco;
    return (_state$persistedDisco = state.persistedDiscoverSession) === null || _state$persistedDisco === void 0 ? void 0 : _state$persistedDisco.id;
  });
  (0, _useMount.default)(() => {
    const redirect = (0, _public.redirectWhenMissing)({
      history,
      navigateToApp,
      basePath,
      mapping: {
        search: '/',
        'index-pattern': {
          app: 'management',
          path: `kibana/objects/search/${discoverSessionId}`
        }
      },
      toastNotifications,
      onBeforeRedirect() {
        urlTracker.setTrackedUrl('/');
      },
      ...core
    });
    redirect(error);
  });
  return /*#__PURE__*/_react.default.createElement(_branded_loading_indicator.BrandedLoadingIndicator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  });
};